package com.digiwin.dap.middleware.dmc.common.parser;

import com.digiwin.dap.middleware.dmc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dmc.internal.model.StdError;
import com.digiwin.dmc.sdk.util.JsonUtils;

/**
 * Used to convert an result stream to a java object.
 *
 * @author fobgochod
 * @date 2021/4/23
 */
public class ErrorResponseParser implements ResponseParser<StdError> {

    @Override
    public StdError parse(ResponseMessage response) throws ResponseParseException {
        return JsonUtils.readValue(response.getError(), StdError.class);
    }
}
