package com.digiwin.dap.middleware.dmc.internal.model;

import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * A generic request that contains some basic request options, such as bucket
 * name, object key, custom headers, progress listener and so on.
 *
 * @author fobgochod
 * @date 2021/4/23
 */
public class GenericRequest extends WebServiceRequest {

    private Map<String, String> headers = new LinkedHashMap<>();
    private long contentLength;

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public long getContentLength() {
        return contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public HttpEntity getEntity() {
        return EntityBuilder.create().build();
    }
}
