package com.digiwin.dap.middleware.dmc.internal.model;

import java.time.LocalDateTime;

public class StdError {

    private LocalDateTime timestamp;
    private Integer code;
    private String message;
    private String path;
    private boolean success;

    private String sourceId;
    private String errorType;
    private String errorCode;
    private String errorMessage;
    private Instructors errorInstructors;
    private DebugInfo debugInfo;

    public LocalDateTime getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getErrorType() {
        return errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Instructors getErrorInstructors() {
        return errorInstructors;
    }

    public void setErrorInstructors(Instructors errorInstructors) {
        this.errorInstructors = errorInstructors;
    }

    public DebugInfo getDebugInfo() {
        return debugInfo;
    }

    public void setDebugInfo(DebugInfo debugInfo) {
        this.debugInfo = debugInfo;
    }

    /**
     * 调试信息
     */
    private static class DebugInfo {
        private String method;
        private String queryParams;
        private String stackTrace;

        public String getMethod() {
            return method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getQueryParams() {
            return queryParams;
        }

        public void setQueryParams(String queryParams) {
            this.queryParams = queryParams;
        }

        public String getStackTrace() {
            return stackTrace;
        }

        public void setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }
    }

    /**
     * 第三方响应的信息
     */
    private static class Instructors {
        private ThirdData sourceAPI;

        public ThirdData getSourceAPI() {
            return sourceAPI;
        }

        public void setSourceAPI(ThirdData sourceAPI) {
            this.sourceAPI = sourceAPI;
        }

        private static class ThirdData {

            private Object response;
            private String url;
            private Integer status;

            public Object getResponse() {
                return response;
            }

            public void setResponse(Object response) {
                this.response = response;
            }

            public String getUrl() {
                return url;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public Integer getStatus() {
                return status;
            }

            public void setStatus(Integer status) {
                this.status = status;
            }
        }
    }
}
