package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.ImageInfo;
import com.digiwin.dap.middleware.dmc.model.ImageRequest;
import com.digiwin.dap.middleware.dmc.model.ImageUpload;

import java.util.List;

/**
 * 图片处理
 *
 * @author fobgochod
 * @date 2021/5/7
 */
public class DMCImageOperation extends DMCOperation {

    public DMCImageOperation(ServiceClient client) {
        super(client);
    }

    public ImageUpload imageUpload(ImageRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getImageUploadUrl(original.getWidth(), original.getHeight()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.imageUploadResponseParser);
    }

    public ImageInfo imageShrink(ImageRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getImageShrinkUrl(original.getFileId(), original.getWidth(), original.getHeight(), original.getShare()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.imageShrinkResponseParser);
    }

    public List<ImageInfo> imageInfo(ImageRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getImageUrl(original.getFileId(), original.getShrink()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.imageInfoResponseParser);
    }
}


