package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.LoginRequest;
import com.digiwin.dap.middleware.dmc.model.LoginUser;

public class DMCLoginOperation extends DMCOperation {

    public DMCLoginOperation(ServiceClient client) {
        super(client);
    }

    public String login(DMCConfig config) throws Exception {
        return login(config, config.getTenantId());
    }

    public String login(DMCConfig config, String tenantId) throws Exception {
        LoginRequest login = new LoginRequest();
        LoginUser loginUser = new LoginUser();
        loginUser.setUsername(config.getUsername());
        loginUser.setPwdhash(config.getPwdhash());
        loginUser.setTenantId(tenantId);
        login.setLoginUser(loginUser);

        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getLoginUrl())
                .setMethod(HttpMethod.POST)
                .setEntity(login.getEntity())
                .setWhitelist(true)
                .build();
        return doOperation(request, ResponseParsers.loginResponseParser);
    }

    public String refresh(String tenantId) throws Exception {
        LoginRequest login = new LoginRequest();
        LoginUser loginUser = new LoginUser();
        loginUser.setTenantId(tenantId);
        login.setLoginUser(loginUser);

        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getRefreshUrl())
                .setMethod(HttpMethod.POST)
                .setEntity(login.getEntity())
                .build();
        return doOperation(request, ResponseParsers.loginResponseParser);
    }
}


