package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.BatchRequest;

/**
 * 删除
 *
 * @author fobgochod
 * @date 2021/5/7
 */
public class DMCRecycleOperation extends DMCOperation {

    public DMCRecycleOperation(ServiceClient client) {
        super(client);
    }

    public void recycleDelete(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getRecycleUrl(original.getRecycleId()))
                .setMethod(HttpMethod.DELETE)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void recycleDeleteMulti(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getRecycleMultiUrl())
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void recycleClear(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getRecycleClearUrl())
                .setMethod(HttpMethod.DELETE)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void recycleRestore(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getRecycleRestoreUrl(original.getRecycleId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void recycleRestoreMulti(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getRecycleRestoreMultiUrl())
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }
}
