package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.BatchRequest;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;

/**
 * 分享
 *
 * @author fobgochod
 * @date 2021/5/7
 */
public class DMCShareOperation extends DMCOperation {

    public DMCShareOperation(ServiceClient client) {
        super(client);
    }

    public ShareInfo shareMulti(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getShareMultiUrl())
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.shareMultiResponseParser);
    }

    public void shareDeleteMulti(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getShareDeleteMultiUrl())
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }
}


