package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dmc.sdk.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

/**
 * 目录参数
 *
 * @author fobgochod
 * @date 2021/4/23
 */
public class DirRequest extends GenericRequest {

    private String dirId;
    private DirInfo dirInfo;

    public String getDirId() {
        return dirId;
    }

    public void setDirId(String dirId) {
        this.dirId = dirId;
    }

    public DirInfo getDirInfo() {
        return dirInfo;
    }

    public void setDirInfo(DirInfo dirInfo) {
        this.dirInfo = dirInfo;
    }

    @Override
    public HttpEntity getEntity() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValueAsString(dirInfo))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
