package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dmc.sdk.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

/**
 * 文件信息
 *
 * @author fobgochod
 * @date 2021/5/11
 */
public class FileInfoRequest extends GenericRequest {

    private String fileId;
    private FileInfo fileInfo;

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public FileInfo getFileInfo() {
        return fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    @Override
    public HttpEntity getEntity() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValueAsString(fileInfo))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
