package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dmc.sdk.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

import java.util.List;

/**
 * 文件信息
 *
 * @author fobgochod
 * @date 2023/5/5 11:27
 */
public class FileInfosRequest extends GenericRequest {

    private String dirId;
    private List<String> fileIds;

    public String getDirId() {
        return dirId;
    }

    public void setDirId(String dirId) {
        this.dirId = dirId;
    }

    public List<String> getFileIds() {
        return fileIds;
    }

    public void setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
    }

    @Override
    public HttpEntity getEntity() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValueAsString(fileIds))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
