package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.DMCConstants;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;

/**
 * 分段上传参数
 *
 * @author fobgochod
 * @date 2021/4/23
 */
public class PartUploader {

    private long partSize = DMCConstants.DEFAULT_PART_SIZE;

    private String fileId;
    private byte[] parts;
    private long from;
    private long to;
    private long total;

    public long getPartSize() {
        return partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public byte[] getParts() {
        return parts;
    }

    public void setParts(byte[] parts) {
        this.parts = parts;
    }

    public long getFrom() {
        return from;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public long getTo() {
        return to;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public HttpEntity getEntity() {
        return EntityBuilder.create().setBinary(parts).build();
    }
}
