package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

import java.io.File;
import java.io.InputStream;

/**
 * 上传参数
 *
 * @author fobgochod
 * @date 2021/4/23
 */
public class UploadCoverRequest extends GenericRequest {

    private File file;
    private byte[] bytes;
    private InputStream input;
    private String fileId;
    private FileInfo fileInfo;

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public byte[] getBytes() {
        return bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public InputStream getInput() {
        return input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public FileInfo getFileInfo() {
        return fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    @Override
    public HttpEntity getEntity() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (file != null) {
            builder.addBinaryBody("file", file);
        } else if (bytes != null) {
            builder.addBinaryBody("file", bytes, ContentType.DEFAULT_BINARY, fileInfo.getFileName());
        } else if (input != null) {
            builder.addBinaryBody("file", input, ContentType.DEFAULT_BINARY, fileInfo.getFileName());
        }
        if (fileId != null) {
            builder.addTextBody("fileId", fileId);
        }
        return builder.build();
    }
}
