package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dmc.sdk.util.JsonUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * 上传参数
 *
 * @author fobgochod
 * @date 2021/4/23
 */
public class UploadMultiRequest extends GenericRequest {

    private List<File> files;
    private List<byte[]> bytes;
    private List<InputStream> inputs;
    private List<FileInfo> fileInfos;

    public UploadMultiRequest() {
        this.files = new ArrayList<>();
        this.bytes = new ArrayList<>();
        this.inputs = new ArrayList<>();
        this.fileInfos = new ArrayList<>();
    }

    public List<File> getFiles() {
        return files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public List<byte[]> getBytes() {
        return bytes;
    }

    public void setBytes(List<byte[]> bytes) {
        this.bytes = bytes;
    }

    public List<InputStream> getInputs() {
        return inputs;
    }

    public void setInputs(List<InputStream> inputs) {
        this.inputs = inputs;
    }

    public List<FileInfo> getFileInfos() {
        return fileInfos;
    }

    public void setFileInfos(List<FileInfo> fileInfos) {
        this.fileInfos = fileInfos;
    }

    @Override
    public HttpEntity getEntity() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (!files.isEmpty()) {
            files.forEach(file -> {
                builder.addBinaryBody("files", file);
            });
        } else if (!bytes.isEmpty()) {
            for (int i = 0; i < bytes.size(); i++) {
                builder.addBinaryBody("files", bytes.get(i), ContentType.DEFAULT_BINARY, fileInfos.get(i).getFileName());
            }
        } else if (!inputs.isEmpty()) {
            for (int i = 0; i < inputs.size(); i++) {
                builder.addBinaryBody("files", inputs.get(i), ContentType.DEFAULT_BINARY, fileInfos.get(i).getFileName());
            }
        }
        if (!fileInfos.isEmpty()) {
            builder.addTextBody("fileInfos", JsonUtils.writeValueAsString(fileInfos),
                    ContentType.create("application/json", Consts.UTF_8));
        }
        return builder.build();
    }
}
