package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dmc.sdk.util.JsonUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

import java.io.File;
import java.io.InputStream;

/**
 * 上传参数
 *
 * @author fobgochod
 * @date 2021/4/23
 */
public class UploadRequest extends GenericRequest {

    private File file;
    private byte[] bytes;
    private InputStream input;
    private FileInfo fileInfo;

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public byte[] getBytes() {
        return bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public InputStream getInput() {
        return input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    public FileInfo getFileInfo() {
        return fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    @Override
    public HttpEntity getEntity() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (file != null) {
            builder.addBinaryBody("file", file);
        } else if (bytes != null) {
            builder.addBinaryBody("file", bytes, ContentType.DEFAULT_BINARY, fileInfo.getFileName());
        } else if (input != null) {
            builder.addBinaryBody("file", input, ContentType.DEFAULT_BINARY, fileInfo.getFileName());
        }
        if (fileInfo != null) {
            builder.addTextBody("fileInfo", JsonUtils.writeValueAsString(fileInfo),
                    ContentType.create("application/json", Consts.UTF_8));
        }
        return builder.build();
    }
}
