package com.digiwin.dmc.sdk.identity;

import com.digiwin.dap.middleware.dmc.internal.DMCConstants;
import com.digiwin.dmc.sdk.util.AESCipher;

import java.util.Objects;

public class UserIdentity {

    private String tenantId;
    private String userName;
    private String password;
    private String passwordHash;

    public UserIdentity() {
    }

    public UserIdentity(String userName, String password) {
        this(userName, password, false);
    }

    public UserIdentity(String userName, String password, boolean hash) {
        this.userName = userName;
        if (hash) {
            this.password = password;
        } else {
            this.password = password;
            this.passwordHash = AESCipher.getSHA256StrJava(password);
        }
    }

    public static UserIdentity getUserIdentity(String userName, String password) {
        return new UserIdentity(userName, password);
    }

    public static UserIdentity getSecureUserIdentity(String userName, String passwordHash) {
        return new UserIdentity(userName, passwordHash, true);
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordHash() {
        return passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String uniqueKey() {
        return String.format("%s::%s", userName, tenantId == null ? DMCConstants.DEFAULT_TENANT : tenantId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserIdentity that = (UserIdentity) o;
        return Objects.equals(tenantId, that.tenantId) && userName.equals(that.userName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, userName);
    }
}
