package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;

/**
 * 下载
 * /api/dmc/v1/buckets/{bucket}/files/{fileId}
 *
 * @author chenzwd
 * @date 2018-06-30 16:02
 */
public class GeneralDocumentDownloader implements IGeneralDocumentDownloader {

    private String discardTenantId;
    private String bucketName;
    private String fileId;
    private String driveToken;
    private TenantId[] tenantId;
    private OutputStream outputStream;
    private IDownLoadCallbackable completeCallback;
    private DownloadProgressEventArgs eventArgs = new DownloadProgressEventArgs();

    private GeneralDocumentDownloader(String discardTenantId, String bucketName, String fileId, String driveToken, TenantId... tenantId) {
        this.discardTenantId = discardTenantId;
        this.bucketName = bucketName;
        this.fileId = fileId;
        this.driveToken = driveToken;
        this.tenantId = tenantId;
    }

    public GeneralDocumentDownloader(String discardTenantId, String bucketName, String fileId, String saveToPath, String driveToken, TenantId... tenantId) {
        this(discardTenantId, bucketName, fileId, driveToken, tenantId);
        try {
            this.outputStream = Files.newOutputStream(Paths.get(saveToPath));
        } catch (IOException e) {
            throw new OperateException(e);
        }
        this.eventArgs.setPercentage(0);
        this.eventArgs.setCompletedBytes(0);
    }

    /**
     * 下载Stream中的文件内容
     */
    @Override
    public IGeneralDocumentDownloader download() {
        bucketName = ArgumentUtils.getBucketName(bucketName);
        String uri = String.format("%s/api/dmc/v1/buckets/%s/files/%s", ServerSetting.getServiceUrl(), bucketName, fileId);

        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, tenantId);

        Runnable runnable = () -> {
            HttpRequestUtil.downloadFile(uri, headers, outputStream);
            if (completeCallback != null) {
                eventArgs.setPercentage(1);
                completeCallback.callback(eventArgs);
            }
        };
        ExecutorUtil.newExecutor().execute(runnable);
        return this;
    }

    /**
     * 设置完成
     */
    @Override
    public IGeneralDocumentDownloader onCompleted(IDownLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}
