package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.dmc.internal.DMCHeaders;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.BatchOperationIds;
import com.digiwin.dmc.sdk.entity.ContentsResult;
import com.digiwin.dmc.sdk.entity.DirInfo;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.entity.Query.FileInfoQuery;
import com.digiwin.dmc.sdk.entity.Query.FullTextCondition;
import com.digiwin.dmc.sdk.entity.Query.QueryResult;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IDocumentStorageService;
import com.digiwin.dmc.sdk.service.discard.DocumentStorageServiceDiscard;
import com.digiwin.dmc.sdk.service.download.GeneralDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.IGeneralDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.ISegmentDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.SegmentSegmentDocumentDownloader;
import com.digiwin.dmc.sdk.service.upload.*;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author chenzwd
 * @date 2018-06-14 14:19
 */
public class DocumentStorageService extends DocumentStorageServiceDiscard implements IDocumentStorageService {

    /**
     * 单一实例
     */
    public static IDocumentStorageService instance() {
        return Holder.instance;
    }

    /*****************************************************************************************************************/

    @Override
    public IGeneralDocumentUploader uploadDocument(byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocument(null, bytes, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocument(bucketName, bytes, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        ArgumentUtils.uploadBytes(bytes, fileInfo);
        return new GeneralDocumentUploader(null, bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String localPath, FileInfo fileInfo) {
        return this.uploadDocument(null, localPath, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo) {
        return this.uploadDocument(bucketName, localPath, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        ArgumentUtils.uploadLocal(localPath, fileInfo);
        return new GeneralDocumentUploader(null, bucketName, localPath, fileInfo, driveToken);
    }

    /*****************************************************************************************************************/

    @Override
    public ISegmentDocumentUploader getUploader(byte[] bytes, FileInfo fileInfo) {
        return this.getUploader(null, bytes, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.getUploader(bucketName, bytes, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        ArgumentUtils.uploadBytes(bytes, fileInfo);
        return new SegmentDocumentUploader(null, bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String localPath, FileInfo fileInfo) {
        return this.getUploader(null, localPath, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, String localPath, FileInfo fileInfo) {
        return this.getUploader(bucketName, localPath, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        ArgumentUtils.uploadLocal(localPath, fileInfo);
        return new SegmentDocumentUploader(null, bucketName, localPath, fileInfo, driveToken);
    }

    /*****************************************************************************************************************/

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(byte[] bytes, String fileId, TenantId... tenantId) {
        return this.coverUploadDocument(null, bytes, fileId, null, tenantId);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, byte[] bytes, String fileId, TenantId... tenantId) {
        return this.coverUploadDocument(null, bytes, fileId, null, tenantId);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, byte[] bytes, String fileId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.uploadBytes(bytes, fileId, tenantId);
        return new CoverGeneralDocumentUploader(bucketName, bytes, fileId, driveToken, tenantId);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String localPath, String fileId, TenantId... tenantId) {
        return this.coverUploadDocument(null, localPath, fileId, null, tenantId);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, String localPath, String fileId, TenantId... tenantId) {
        return this.coverUploadDocument(null, localPath, fileId, null, tenantId);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, String localPath, String fileId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.uploadLocal(localPath, fileId, tenantId);
        return new CoverGeneralDocumentUploader(bucketName, localPath, fileId, driveToken, tenantId);
    }

    /*****************************************************************************************************************/

    @Override
    public ICoverSegmentDocumentUploader getUploader(byte[] bytes, String fileId, TenantId... tenantId) {
        return this.getUploader(null, bytes, fileId, null, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, byte[] bytes, String fileId, TenantId... tenantId) {
        return this.getUploader(bucketName, bytes, fileId, null, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, byte[] bytes, String fileId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.uploadBytes(bytes, fileId, tenantId);
        return new CoverSegmentDocumentUploader(bucketName, bytes, fileId, driveToken, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String localPath, String fileId, TenantId... tenantId) {
        return this.getUploader(null, localPath, fileId, null, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, String localPath, String fileId, TenantId... tenantId) {
        return this.getUploader(bucketName, localPath, fileId, null, tenantId);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, String localPath, String fileId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.uploadLocal(localPath, fileId, tenantId);
        return new CoverSegmentDocumentUploader(bucketName, localPath, fileId, driveToken, tenantId);
    }

    /*****************************************************************************************************************/

    @Override
    public IGeneralDocumentDownloader downloadDocument(String fileId, String saveToPath, TenantId... tenantId) {
        return this.downloadDocument(null, fileId, saveToPath, null, tenantId);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocument(String bucketName, String fileId, String saveToPath, TenantId... tenantId) {
        return this.downloadDocument(bucketName, fileId, saveToPath, null, tenantId);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocument(String bucketName, String fileId, String saveToPath, String driveToken, TenantId... tenantId) {
        ArgumentUtils.download(fileId, saveToPath, tenantId);
        File file = new File(saveToPath);
        if (file.isDirectory()) {
            FileInfo fileInfo = this.getDocumentInfo(bucketName, fileId);
            saveToPath += "\\" + fileInfo.getFileName();
        }
        return new GeneralDocumentDownloader(null, bucketName, fileId, saveToPath, driveToken, tenantId);
    }

    /*****************************************************************************************************************/

    @Override
    public ISegmentDocumentDownloader getDownloader(String fileId, String saveToPath, TenantId... tenantId) {
        return this.getDownloader(null, fileId, saveToPath, null, tenantId);
    }

    @Override
    public ISegmentDocumentDownloader getDownloader(String bucketName, String fileId, String saveToPath, TenantId... tenantId) {
        return this.getDownloader(bucketName, fileId, saveToPath, null, tenantId);
    }

    @Override
    public ISegmentDocumentDownloader getDownloader(String bucketName, String fileId, String saveToPath, String driveToken, TenantId... tenantId) {
        ArgumentUtils.download(fileId, saveToPath, tenantId);
        FileInfo fileInfo = this.getDocumentInfo(bucketName, fileId);
        File file = new File(saveToPath);
        if (file.isDirectory()) {
            saveToPath += "\\" + fileInfo.getFileName();
        }
        return new SegmentSegmentDocumentDownloader(null, bucketName, fileId, saveToPath, (int) fileInfo.getSize(), driveToken, tenantId);
    }

    /*****************************************************************************************************************/


    @Override
    public String deleteDocument(String fileId, TenantId... tenantId) {
        return this.deleteDocument(null, fileId, null, tenantId);
    }

    @Override
    public String deleteDocument(String bucketName, String fileId, TenantId... tenantId) {
        return this.deleteDocument(bucketName, fileId, null, tenantId);
    }

    @Override
    public String deleteDocument(String bucketName, String fileId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.fileInfo(fileId, tenantId);
        String uri = String.format("%s/api/dmc/v1/buckets/%s/files/%s", ServerSetting.getServiceUrl(),
                ArgumentUtils.getBucketName(bucketName), fileId);

        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        Map responseEntity = HttpRequestUtil.delete(uri, headers, HashMap.class);
        if (null == responseEntity || !responseEntity.containsKey("recycleBinId")) {
            return null;
        } else {
            return responseEntity.get("recycleBinId").toString();
        }
    }

    /*****************************************************************************************************************/


    @Override
    public void deleteManyDocument(BatchOperationIds operationIds, TenantId... tenantId) {
        this.deleteManyDocument(null, operationIds, null, tenantId);
    }

    @Override
    public void deleteManyDocument(String bucketName, BatchOperationIds operationIds, TenantId... tenantId) {
        this.deleteManyDocument(bucketName, operationIds, null, tenantId);
    }

    @Override
    public void deleteManyDocument(String bucketName, BatchOperationIds operationIds, String driveToken, TenantId... tenantId) {
        ArgumentUtils.fileInfo(operationIds, tenantId);
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/files/delete/batch", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName));

            Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
            HttpRequestUtil.postJson(uri, ObjectMapperUtil.writeValueAsString(operationIds), headers, String.class);
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /*****************************************************************************************************************/

    @Override
    public void updateDocument(String fileId, String fileName, TenantId... tenantId) {
        this.updateDocument(null, fileId, fileName, null, tenantId);
    }

    @Override
    public void updateDocument(String bucketName, String fileId, String fileName, TenantId... tenantId) {
        this.updateDocument(bucketName, fileId, fileName, null, tenantId);
    }

    @Override
    public void updateDocument(String bucketName, String fileId, String fileName, String driveToken, TenantId... tenantId) {
        ArgumentUtils.fileInfo(fileId, fileName, tenantId);
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/files/%s/rename/%s", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), fileId, fileName);

            Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
            HttpRequestUtil.postJson(uri, "", headers, String.class);
        } catch (IOException e) {
            throw new OperateException(e);
        }
    }

    /*****************************************************************************************************************/

    @Override
    public FileInfo getDocumentInfo(String fileId, TenantId... tenantId) {
        return this.getDocumentInfo(null, fileId, null, tenantId);
    }

    @Override
    public FileInfo getDocumentInfo(String bucketName, String fileId, TenantId... tenantId) {
        return this.getDocumentInfo(bucketName, fileId, null, tenantId);
    }

    @Override
    public FileInfo getDocumentInfo(String bucketName, String fileId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.fileInfo(fileId, tenantId);
        String uri = String.format("%s/api/dmc/v1/buckets/%s/files/%s/info", ServerSetting.getServiceUrl(),
                ArgumentUtils.getBucketName(bucketName), fileId);

        Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
        return HttpRequestUtil.get(uri, headers, FileInfo.class);
    }

    /*****************************************************************************************************************/

    @Override
    public String copyDocument(String fileId, String targetDirectoryId, TenantId... tenantId) {
        return this.copyDocument(null, fileId, targetDirectoryId, null, tenantId);
    }

    @Override
    public String copyDocument(String bucketName, String fileId, String targetDirectoryId, TenantId... tenantId) {
        return this.copyDocument(bucketName, fileId, targetDirectoryId, null, tenantId);
    }

    @Override
    public String copyDocument(String bucketName, String fileId, String targetDirectoryId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.fileInfo(fileId, tenantId);
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/files/%s/copyto/directory/%s", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), fileId, ArgumentUtils.getDirectoryId(targetDirectoryId));

            Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
            Map responseEntity = HttpRequestUtil.postJson(uri, "", headers, HashMap.class);
            if (null == responseEntity || !responseEntity.containsKey("id")) {
                return null;
            } else {
                return responseEntity.get("id").toString();
            }
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /*****************************************************************************************************************/

    @Override
    public void copyManyDocument(BatchOperationIds operationIds, String targetDirectoryId, TenantId... tenantId) {
        this.copyManyDocument(null, operationIds, targetDirectoryId, null, tenantId);
    }

    @Override
    public void copyManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId, TenantId... tenantId) {
        this.copyManyDocument(bucketName, operationIds, targetDirectoryId, null, tenantId);
    }

    @Override
    public void copyManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.fileInfo(operationIds, tenantId);
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/files/copy/batch/directory/%s", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), ArgumentUtils.getDirectoryId(targetDirectoryId));

            Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
            HttpRequestUtil.postJson(uri, ObjectMapperUtil.writeValueAsString(operationIds), headers, List.class);
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /*****************************************************************************************************************/

    @Override
    public void moveDocument(String fileId, String targetDirectoryId, TenantId... tenantId) {
        this.moveDocument(null, fileId, targetDirectoryId, null, tenantId);
    }

    @Override
    public void moveDocument(String bucketName, String fileId, String targetDirectoryId, TenantId... tenantId) {
        this.moveDocument(bucketName, fileId, targetDirectoryId, null, tenantId);
    }

    @Override
    public void moveDocument(String bucketName, String fileId, String targetDirectoryId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.fileInfo(fileId, tenantId);
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/files/%s/moveto/directory/%s", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), fileId, ArgumentUtils.getDirectoryId(targetDirectoryId));

            Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
            HttpRequestUtil.postJson(uri, "", headers, String.class);
        } catch (IOException e) {
            throw new OperateException(e);
        }
    }

    /*****************************************************************************************************************/

    @Override
    public void moveManyDocument(BatchOperationIds operationIds, String targetDirectoryId, TenantId... tenantId) {
        this.moveManyDocument(null, operationIds, targetDirectoryId, null, tenantId);
    }

    @Override
    public void moveManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId, TenantId... tenantId) {
        this.moveManyDocument(bucketName, operationIds, targetDirectoryId, null, tenantId);
    }

    @Override
    public void moveManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.fileInfo(operationIds, tenantId);
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/files/move/batch/directory/%s", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), ArgumentUtils.getDirectoryId(targetDirectoryId));

            Map<String, String> headers = HttpUtils.setHeader(driveToken, tenantId);
            HttpRequestUtil.postJson(uri, ObjectMapperUtil.writeValueAsString(operationIds), headers, String.class);
        } catch (IOException e) {
            throw new OperateException(e);
        }
    }

    /*****************************************************************************************************************/

    @Override
    public String createDirectory(String directoryName, String parentDirectoryId) {
        return this.createDirectory(null, directoryName, parentDirectoryId, null);
    }

    @Override
    public String createDirectory(String bucketName, String directoryName, String parentDirectoryId) {
        return this.createDirectory(bucketName, directoryName, parentDirectoryId, null);
    }

    @Override
    public String createDirectory(String bucketName, String directoryName, String parentDirectoryId, String driveToken) {
        ArgumentUtils.directoryName(directoryName);
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/directorys", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName));

            Map<String, String> parameters = new HashMap<>();
            parameters.put("parentId", ArgumentUtils.getDirectoryId(parentDirectoryId));
            parameters.put("name", directoryName);
            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            Map responseEntity = HttpRequestUtil.postJson(uri, ObjectMapperUtil.writeValueAsString(parameters), headers, HashMap.class);
            if (null == responseEntity || !responseEntity.containsKey("dirId")) {
                return null;
            } else {
                return responseEntity.get("dirId").toString();
            }
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /*****************************************************************************************************************/

    @Override
    public String deleteDirectory(String directoryId) {
        return this.deleteDirectory(null, directoryId, null);
    }

    @Override
    public String deleteDirectory(String bucketName, String directoryId) {
        return this.deleteDirectory(bucketName, directoryId, null);
    }

    @Override
    public String deleteDirectory(String bucketName, String directoryId, String driveToken) {
        ArgumentUtils.directory(directoryId);
        String uri = String.format("%s/api/dmc/v1/buckets/%s/directorys/%s", ServerSetting.getServiceUrl(),
                ArgumentUtils.getBucketName(bucketName), directoryId);


        Map<String, String> headers = HttpUtils.setHeader(driveToken);
        Map responseEntity = HttpRequestUtil.delete(uri, headers, HashMap.class);
        if (null == responseEntity || !responseEntity.containsKey("recycleBinId")) {
            return null;
        } else {
            return responseEntity.get("recycleBinId").toString();
        }

    }

    /*****************************************************************************************************************/

    @Override
    public void updateDirectory(String directoryId, String directoryName) {
        this.updateDirectory(null, directoryId, directoryName, null);
    }

    @Override
    public void updateDirectory(String bucketName, String directoryId, String directoryName) {
        this.updateDirectory(bucketName, directoryId, directoryName, null);
    }

    @Override
    public void updateDirectory(String bucketName, String directoryId, String directoryName, String driveToken) {
        ArgumentUtils.directory(directoryId, directoryName);
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/directorys/%s/rename/%s", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), directoryId, directoryName);

            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            HttpRequestUtil.postJson(uri, "", headers, String.class);
        } catch (IOException e) {
            throw new OperateException(e);
        }
    }

    /*****************************************************************************************************************/

    @Override
    public DirInfo getDirectoryInfo(String directoryId) {
        return this.getDirectoryInfo(null, directoryId, null);
    }

    @Override
    public DirInfo getDirectoryInfo(String bucketName, String directoryId) {
        return this.getDirectoryInfo(bucketName, directoryId, null);
    }

    @Override
    public DirInfo getDirectoryInfo(String bucketName, String directoryId, String driveToken) {
        ArgumentUtils.directory(directoryId);
        String uri = String.format("%s/api/dmc/v1/buckets/%s/directorys/%s", ServerSetting.getServiceUrl(),
                ArgumentUtils.getBucketName(bucketName), directoryId);

        Map<String, String> headers = HttpUtils.setHeader(driveToken);
        return HttpRequestUtil.get(uri, headers, DirInfo.class);

    }

    /*****************************************************************************************************************/

    @Override
    public String copyDirectory(String directoryId, String targetDirectoryId) {
        return this.copyDirectory(null, directoryId, targetDirectoryId, null);
    }

    @Override
    public String copyDirectory(String bucketName, String directoryId, String targetDirectoryId) {
        return this.copyDirectory(bucketName, directoryId, targetDirectoryId, null);
    }

    @Override
    public String copyDirectory(String bucketName, String directoryId, String targetDirectoryId, String driveToken) {
        ArgumentUtils.directory(directoryId);
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/directorys/%s/copyto/%s", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), directoryId, ArgumentUtils.getDirectoryId(targetDirectoryId));

            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            Map responseEntity = HttpRequestUtil.postJson(uri, "", headers, HashMap.class);
            if (responseEntity == null || !responseEntity.containsKey("dirId")) {
                return null;
            } else {
                return responseEntity.get("dirId").toString();
            }
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /*****************************************************************************************************************/


    @Override
    public void moveDirectory(String directoryId, String targetDirectoryId) {
        this.moveDirectory(null, directoryId, targetDirectoryId, null);
    }

    @Override
    public void moveDirectory(String bucketName, String directoryId, String targetDirectoryId) {
        this.moveDirectory(bucketName, directoryId, targetDirectoryId, null);
    }

    @Override
    public void moveDirectory(String bucketName, String directoryId, String targetDirectoryId, String driveToken) {
        try {
            ArgumentUtils.directory(directoryId);
            String uri = String.format("%s/api/dmc/v1/buckets/%s/directorys/%s/moveto/%s", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), directoryId, ArgumentUtils.getDirectoryId(targetDirectoryId));

            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            HttpRequestUtil.postJson(uri, "", headers, String.class);
        } catch (IOException e) {
            throw new OperateException(e);
        }
    }

    /*****************************************************************************************************************/

    @Override
    public ContentsResult listContents(String directoryId) {
        return this.listContents(null, directoryId, null);
    }

    @Override
    public ContentsResult listContents(String bucketName, String directoryId) {
        return this.listContents(bucketName, directoryId, null);
    }

    @Override
    public ContentsResult listContents(String bucketName, String directoryId, String driveToken) {
        String uri = String.format("%s/api/dmc/v1/buckets/%s/directorys/%s/list", ServerSetting.getServiceUrl(),
                ArgumentUtils.getBucketName(bucketName), ArgumentUtils.getDirectoryId(directoryId));
        Map<String, String> headers = HttpUtils.setHeader(driveToken);
        return HttpRequestUtil.get(uri, headers, ContentsResult.class);
    }

    /**
     * 根据FileInfoQuery查询文档
     *
     * @return 查询结果
     */
    @Override
    public QueryResult queryFileInfoByFileInfoQuery(FileInfoQuery query) {
        return this.queryFileInfoByFileInfoQuery(null, query, null);
    }

    /*****************************************************************************************************************/

    @Override
    public QueryResult queryFileInfoByFileInfoQuery(String bucketName, FileInfoQuery query) {
        return this.queryFileInfoByFileInfoQuery(bucketName, query, null);
    }

    @Override
    public QueryResult queryFileInfoByFileInfoQuery(String bucketName, FileInfoQuery query, String driveToken) {
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/query", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName));

            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            String json = ObjectMapperUtil.writeValueAsString(query);
            QueryResult responseEntity = HttpRequestUtil.postJson(uri, json, headers, QueryResult.class);
            return responseEntity;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /**
     * 根据单个字段精确查询
     *
     * @param field 字段名
     * @param value 字段值
     * @return 查询结果
     */
    @Override
    public QueryResult queryFileInfoByField(String field, String value) {
        return this.queryFileInfoByField(null, field, value, null);
    }

    @Override
    public QueryResult queryFileInfoByField(String bucketName, String field, String value) {
        return this.queryFileInfoByField(bucketName, field, value, null);
    }

    /**
     * 根据单个字段精确查询
     *
     * @param bucketName 存储区
     * @param field      字段名
     * @param value      字段值
     * @param driveToken driveToken
     * @return 查询结果
     */
    @Override
    public QueryResult queryFileInfoByField(String bucketName, String field, String value, String driveToken) {
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/query/fields/%s/values/%s/", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), field, value);

            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            QueryResult responseEntity = HttpRequestUtil.get(uri, headers, QueryResult.class);
            return responseEntity;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /**
     * 根据单个字段精确查询
     *
     * @param field    字段名
     * @param value    字段值
     * @param pageNum  当前页
     * @param pageSize 显示个数
     * @return 查询结果
     */
    @Override
    public QueryResult queryFileInfoByFieldWithPage(String field, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByFieldWithPage(null, field, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByFieldWithPage(String bucketName, String field, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByFieldWithPage(bucketName, field, value, pageNum, pageSize, null);
    }

    /**
     * 根据单个字段精确查询
     *
     * @param bucketName 存储区
     * @param field      字段名
     * @param value      字段值
     * @param pageNum    当前页
     * @param pageSize   显示个数
     * @param driveToken driveToken
     * @return 查询结果
     */
    @Override
    public QueryResult queryFileInfoByFieldWithPage(String bucketName, String field, String value, String pageNum, String pageSize, String driveToken) {
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/query/fields/%s/values/%s/%s/%s", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), field, value, pageNum, pageSize);

            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            QueryResult responseEntity = HttpRequestUtil.get(uri, headers, QueryResult.class);
            return responseEntity;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /**
     * 单个字段比较查询
     *
     * @param field    字段名
     * @param operator 操作符
     * @param value    字段值
     * @param pageNum  当前页
     * @param pageSize 显示个数
     * @return 查询结果
     */
    @Override
    public QueryResult queryFileInfoByOperatorWithPage(String field, String operator, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByOperatorWithPage(null, field, operator, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByOperatorWithPage(String bucketName, String field, String operator, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByOperatorWithPage(bucketName, field, operator, value, pageNum, pageSize, null);
    }

    /**
     * 单个字段比较查询
     *
     * @param bucketName 存储区
     * @param field      字段名
     * @param operator   操作符
     * @param value      字段值
     * @param pageNum    当前页
     * @param pageSize   显示个数
     * @param driveToken driveToken
     * @return 查询结果
     */
    @Override
    public QueryResult queryFileInfoByOperatorWithPage(String bucketName, String field, String operator, String value, String pageNum, String pageSize, String driveToken) {
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/query/fields/%s/operators/%s/values/%s/%s/%s", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), field, operator, value, pageNum, pageSize);

            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            QueryResult responseEntity = HttpRequestUtil.get(uri, headers, QueryResult.class);
            return responseEntity;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /**
     * 单个字段比较查询
     *
     * @param field    字段名
     * @param operator 操作符
     * @param value    字段值
     * @return 查询结果
     */
    @Override
    public QueryResult queryFileInfoByOperator(String field, String operator, String value) {
        return this.queryFileInfoByOperator(null, field, operator, value, null);
    }

    @Override
    public QueryResult queryFileInfoByOperator(String bucketName, String field, String operator, String value) {
        return this.queryFileInfoByOperator(bucketName, field, operator, value, null);
    }

    /**
     * 单个字段比较查询
     *
     * @param bucketName 存储区
     * @param field      字段名
     * @param operator   操作符
     * @param value      字段值
     * @param driveToken driveToken
     * @return 查询结果
     */
    @Override
    public QueryResult queryFileInfoByOperator(String bucketName, String field, String operator, String value, String driveToken) {
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/query/fields/%s/operators/%s/values/%s/", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName), field, operator, value);

            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            QueryResult responseEntity = HttpRequestUtil.get(uri, headers, QueryResult.class);
            return responseEntity;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /**
     * 全文搜索
     *
     * @param search 索引条件
     * @return
     */
    @Override
    public QueryResult queryFileInfoByFullText(FullTextCondition search) {
        return this.queryFileInfoByFullText(null, search, null);
    }

    @Override
    public QueryResult queryFileInfoByFullText(String bucketName, FullTextCondition search) {
        return this.queryFileInfoByFullText(bucketName, search, null);
    }

    /**
     * 全文搜索指定Bucket
     *
     * @param bucketName 存储区
     * @param search     搜索条件
     * @param driveToken driveToken
     * @return
     */
    @Override
    public QueryResult queryFileInfoByFullText(String bucketName, FullTextCondition search, String driveToken) {
        try {
            String uri = String.format("%s/api/dmc/v1/buckets/%s/query/fulltext", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName));

            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            QueryResult responseEntity = HttpRequestUtil.postJson(uri, ObjectMapperUtil.writeValueAsString(search), headers, QueryResult.class);
            return responseEntity;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /**
     * 全文搜索指定Bucket
     *
     * @param search      搜索条件
     * @param accessToken accessToken
     * @return
     */
    @Override
    public QueryResult queryFileInfoByFullText(FullTextCondition search, String accessToken) {
        try {
            String uri = String.format("%s/api/dmc/v1/query/fulltext", ServerSetting.getServiceUrl());
            Map<String, String> headers = new HashMap<>();
            headers.put(DMCHeaders.HTTP_HEADER_ACCESS_TOKEN_KEY, accessToken);
            QueryResult responseEntity = HttpRequestUtil.postJson(uri, ObjectMapperUtil.writeValueAsString(search), headers, QueryResult.class);
            return responseEntity;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    private static class Holder { // lazy class
        static final IDocumentStorageService instance = new DocumentStorageService();
    }
}
