package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.ImageCacheFile;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IHandleImageService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HandleImageService implements IHandleImageService {

    /**
     * 单一实例
     */
    public static IHandleImageService handleImageInstance() {
        return Holder.instance;
    }

    private byte[] getBytes(String driveToken, String handleImageUrl) {
        Map<String, String> headers = HttpUtils.setHeader(driveToken);
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    /**
     * 图片缩放，按比例
     *
     * @param bucketName 存储区
     * @param fileId     文档id
     * @param scale      比例
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImagePng(String bucketName, String fileId, int scale, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/0/scale/" + scale;

        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImagePng(String bucketName, String fileId, int scale) {
        return this.dealImagePng(bucketName, fileId, scale, null);
    }

    @Override
    public byte[] dealImagePng(String fileId, int scale) {
        return this.dealImagePng(null, fileId, scale, null);
    }

    /**
     * 图片缩放，按比例，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param scale        原图的百分比 0--100
     * @param cornerRadius 圆角半径
     */
    @Override
    public byte[] dealImageRound(String bucketName, String fileId, int scale, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/0/scale/" + scale + "/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageRound(String bucketName, String fileId, int scale, int cornerRadius) {
        return this.dealImageRound(bucketName, fileId, scale, cornerRadius, null);
    }

    @Override
    public byte[] dealImageRound(String fileId, int scale, int cornerRadius) {
        return this.dealImageRound(null, fileId, scale, cornerRadius, null);
    }

    /**
     * 图片缩放，按比例，自定义输出图片格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param scale      原图的百分比 0--100
     * @param format     图片格式
     */
    @Override
    public byte[] dealImage(String bucketName, String fileId, int scale, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/0/scale/" + scale + "/format/" + format;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImage(String bucketName, String fileId, int scale, String format) {
        return this.dealImage(bucketName, fileId, scale, format, null);
    }

    @Override
    public byte[] dealImage(String fileId, int scale, String format) {
        return this.dealImage(null, fileId, scale, format, null);
    }

    /**
     * 图片缩放，高根据宽自适应
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageSetWidth(String bucketName, String fileId, int width, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/0/w/" + width;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageSetWidth(String bucketName, String fileId, int width) {
        return this.dealImage(bucketName, fileId, width, null);
    }

    @Override
    public byte[] dealImageSetWidth(String fileId, int width) {
        return this.dealImage(null, fileId, width, null);
    }

    /**
     * 图片缩放，高根据宽自适应，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param width        宽
     * @param cornerRadius 圆角大小
     * @param driveToken   操作token
     */
    @Override
    public byte[] dealImageSetWidthRound(String bucketName, String fileId, int width, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/0/w/" + width + "/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageSetWidthRound(String bucketName, String fileId, int width, int cornerRadius) {
        return this.dealImageSetWidthRound(bucketName, fileId, width, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSetWidthRound(String fileId, int width, int cornerRadius) {
        return this.dealImageSetWidthRound(null, fileId, width, cornerRadius, null);
    }

    /**
     * 图片缩放，高根据宽自适应，自定义格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param format     图片格式
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageSetWidthFormat(String bucketName, String fileId, int width, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/0/w/" + width + "/format/" + format;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageSetWidthFormat(String bucketName, String fileId, int width, String format) {
        return this.dealImageSetWidthFormat(bucketName, fileId, width, format, null);
    }

    @Override
    public byte[] dealImageSetWidthFormat(String fileId, int width, String format) {
        return this.dealImageSetWidthFormat(null, fileId, width, format, null);
    }

    /**
     * 图片缩放，宽根据高自适应
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param height     高
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageSetHeight(String bucketName, String fileId, int height, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/0/h/" + height;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageSetHeight(String bucketName, String fileId, int height) {
        return this.dealImageSetHeight(bucketName, fileId, height, null);
    }

    @Override
    public byte[] dealImageSetHeight(String fileId, int height) {
        return this.dealImageSetHeight(null, fileId, height, null);
    }

    /**
     * 图片缩放，宽根据高自适应，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param height       高
     * @param cornerRadius 圆角大小
     * @param driveToken   操作token
     */
    @Override
    public byte[] dealImageSetHeightRound(String bucketName, String fileId, int height, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/0/h/" + height + "/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageSetHeightRound(String bucketName, String fileId, int height, int cornerRadius) {
        return this.dealImageSetHeightRound(bucketName, fileId, height, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSetHeightRound(String fileId, int height, int cornerRadius) {
        return this.dealImageSetHeightRound(null, fileId, height, cornerRadius, null);
    }

    /**
     * 图片缩放，宽根据高自适应，自定义格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param height     高
     * @param format     图片格式
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageSetHeightFormat(String bucketName, String fileId, int height, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/0/h/" + height + "/format/" + format;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageSetHeightFormat(String bucketName, String fileId, int height, String format) {
        return this.dealImageSetHeightFormat(bucketName, fileId, height, format, null);
    }

    @Override
    public byte[] dealImageSetHeightFormat(String fileId, int height, String format) {
        return this.dealImageSetHeightFormat(null, fileId, height, format, null);
    }

    /**
     * 图片缩放,居中剪裁,默认png,设置宽高
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param height     高
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageClipPng(String bucketName, String fileId, int width, int height, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/1/w/" + width + "/h/" + height;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageClipPng(String bucketName, String fileId, int width, int height) {
        return this.dealImageClipPng(bucketName, fileId, width, height, null);
    }

    @Override
    public byte[] dealImageClipPng(String fileId, int width, int height) {
        return this.dealImageClipPng(null, fileId, width, height, null);
    }

    /**
     * 图片缩放,居中剪裁,默认png,设置宽高，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param width        宽
     * @param height       高
     * @param cornerRadius 圆角半径
     * @param driveToken   操作token
     */
    @Override
    public byte[] dealImageClipRound(String bucketName, String fileId, int width, int height, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/1/w/" + width + "/h/" + height + "/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageClipRound(String bucketName, String fileId, int width, int height, int cornerRadius) {
        return this.dealImageClipRound(bucketName, fileId, width, height, cornerRadius, null);
    }

    @Override
    public byte[] dealImageClipRound(String fileId, int width, int height, int cornerRadius) {
        return this.dealImageClipRound(null, fileId, width, height, cornerRadius, null);
    }

    /**
     * 图片缩放,居中剪裁，自定义格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param height     高
     * @param format     图片输出的格式
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageClipFormat(String bucketName, String fileId, int width, int height, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/1/w/" + width + "/h/" + height + "/format/" + format;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageClipFormat(String bucketName, String fileId, int width, int height, String format) {
        return this.dealImageClipFormat(bucketName, fileId, width, height, format, null);
    }

    @Override
    public byte[] dealImageClipFormat(String fileId, int width, int height, String format) {
        return this.dealImageClipFormat(null, fileId, width, height, format, null);
    }

    /**
     * 图片缩放,居中剪裁,根据宽生成正方形
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageClipSetWidth(String bucketName, String fileId, int width, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/1/w/" + width;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageClipSetWidth(String bucketName, String fileId, int width) {
        return this.dealImageClipSetWidth(bucketName, fileId, width, null);
    }

    @Override
    public byte[] dealImageClipSetWidth(String fileId, int width) {
        return this.dealImageClipSetWidth(null, fileId, width, null);
    }

    /**
     * 图片缩放,居中剪裁,根据宽生成正方形，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param width        宽
     * @param cornerRadius 圆角半径
     * @param driveToken   操作token
     */
    @Override
    public byte[] dealImageClipSetWidthRound(String bucketName, String fileId, int width, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/1/w/" + width + "/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageClipSetWidthRound(String bucketName, String fileId, int width, int cornerRadius) {
        return this.dealImageClipSetWidthRound(bucketName, fileId, width, cornerRadius, null);
    }

    @Override
    public byte[] dealImageClipSetWidthRound(String fileId, int width, int cornerRadius) {
        return this.dealImageClipSetWidthRound(null, fileId, width, cornerRadius, null);
    }

    /**
     * 图片缩放,居中剪裁,根据宽生成正方形，自定义格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param width      宽
     * @param format     图片格式
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageClipSetWidthFormat(String bucketName, String fileId, int width, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/1/w/" + width + "/format/" + format;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageClipSetWidthFormat(String bucketName, String fileId, int width, String format) {
        return this.dealImageClipSetWidthFormat(bucketName, fileId, width, format, null);
    }

    @Override
    public byte[] dealImageClipSetWidthFormat(String fileId, int width, String format) {
        return this.dealImageClipSetWidthFormat(null, fileId, width, format, null);
    }

    /**
     * 图片缩放,居中剪裁,根据高生成正方形
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param height     高
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageClipSetHeight(String bucketName, String fileId, int height, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/1/h/" + height;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageClipSetHeight(String bucketName, String fileId, int height) {
        return this.dealImageClipSetHeight(bucketName, fileId, height, null);
    }

    @Override
    public byte[] dealImageClipSetHeight(String fileId, int height) {
        return this.dealImageClipSetHeight(null, fileId, height, null);
    }

    /**
     * 图片缩放,居中剪裁,根据高生成正方形，圆角处理
     *
     * @param bucketName   存储区
     * @param fileId       文件id
     * @param height       高
     * @param cornerRadius 圆角半径
     * @param driveToken   操作token
     */
    @Override
    public byte[] dealImageClipSetHeightRound(String bucketName, String fileId, int height, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/1/h/" + height + "/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageClipSetHeightRound(String bucketName, String fileId, int height, int cornerRadius) {
        return this.dealImageClipSetHeightRound(bucketName, fileId, height, cornerRadius, null);
    }

    @Override
    public byte[] dealImageClipSetHeightRound(String fileId, int height, int cornerRadius) {
        return this.dealImageClipSetHeightRound(null, fileId, height, cornerRadius, null);
    }

    /**
     * 图片缩放,居中剪裁,根据高生成正方形，自定义格式
     *
     * @param bucketName 存储区
     * @param fileId     文件id
     * @param height     高
     * @param format     图片格式
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageClipSetHeightFormat(String bucketName, String fileId, int height, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/1/h/" + height + "/format/" + format;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageClipSetHeightFormat(String bucketName, String fileId, int height, String format) {
        return this.dealImageClipSetHeightFormat(bucketName, fileId, height, format, null);
    }

    @Override
    public byte[] dealImageClipSetHeightFormat(String fileId, int height, String format) {
        return this.dealImageClipSetHeightFormat(null, fileId, height, format, null);
    }

    /**
     * 处理图片 256*256
     *
     * @param bucketName   存储区
     * @param fileId       图片文件id
     * @param cornerRadius 圆角半径
     * @param driveToken   操作token
     */
    @Override
    public byte[] dealImageLarger(String bucketName, String fileId, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/larger/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageLarger(String bucketName, String fileId, int cornerRadius) {
        return this.dealImageLarger(bucketName, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageLarger(String fileId, int cornerRadius) {
        return this.dealImageLarger(null, fileId, cornerRadius, null);
    }

    /**
     * 处理图片 64*64
     *
     * @param bucketName   存储区
     * @param fileId       图片文件id
     * @param cornerRadius 圆角半径
     * @param driveToken   操作token
     */
    @Override
    public byte[] dealImageLarge(String bucketName, String fileId, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/large/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageLarge(String bucketName, String fileId, int cornerRadius) {
        return this.dealImageLarge(bucketName, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageLarge(String fileId, int cornerRadius) {
        return this.dealImageLarge(null, fileId, cornerRadius, null);
    }

    /**
     * 处理图片 32*32
     *
     * @param bucketName   存储区
     * @param fileId       图片文件id
     * @param cornerRadius 圆角半径
     * @param driveToken   操作token
     */
    @Override
    public byte[] dealImageMiddle(String bucketName, String fileId, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/middle/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageMiddle(String bucketName, String fileId, int cornerRadius) {
        return this.dealImageMiddle(bucketName, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageMiddle(String fileId, int cornerRadius) {
        return this.dealImageMiddle(null, fileId, cornerRadius, null);
    }

    /**
     * 处理图片 20*20
     *
     * @param bucketName   存储区
     * @param fileId       图片文件id
     * @param cornerRadius 圆角半径
     * @param driveToken   操作token
     */
    @Override
    public byte[] dealImageSmall(String bucketName, String fileId, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/small/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageSmall(String bucketName, String fileId, int cornerRadius) {
        return this.dealImageSmall(bucketName, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSmall(String fileId, int cornerRadius) {
        return this.dealImageMiddle(null, fileId, cornerRadius, null);
    }

    /**
     * 处理图片 16*16
     *
     * @param bucketName   存储区
     * @param fileId       图片文件id
     * @param cornerRadius 圆角半径
     * @param driveToken   操作token
     */
    @Override
    public byte[] dealImageSmaller(String bucketName, String fileId, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/smaller/" + cornerRadius;
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageSmaller(String bucketName, String fileId, int cornerRadius) {
        return this.dealImageSmaller(bucketName, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSmaller(String fileId, int cornerRadius) {
        return this.dealImageSmaller(null, fileId, cornerRadius, null);
    }

    /**
     * android
     *
     * @param bucketName 存储区
     * @param fileId     图片文件id
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageForAndroid(String bucketName, String fileId, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/forAndroid";
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageForAndroid(String bucketName, String fileId) {
        return this.dealImageForAndroid(bucketName, fileId, null);
    }

    @Override
    public byte[] dealImageForAndroid(String fileId) {
        return this.dealImageForAndroid(null, fileId, null);
    }

    /**
     * pad
     *
     * @param bucketName 存储区
     * @param fileId     图片文件id
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageForPad(String bucketName, String fileId, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/forPad";
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageForPad(String bucketName, String fileId) {
        return this.dealImageForPad(bucketName, fileId, null);
    }

    @Override
    public byte[] dealImageForPad(String fileId) {
        return this.dealImageForPad(null, fileId, null);
    }

    /**
     * ios
     *
     * @param bucketName 存储区
     * @param fileId     图片文件id
     * @param driveToken 操作token
     */
    @Override
    public byte[] dealImageForIos(String bucketName, String fileId, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if ((fileId == null) || ("".equals(fileId))) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl()
                + bucketName + "/images/" + fileId + "/view/forIos";
        return getBytes(driveToken, handleImageUrl);
    }

    @Override
    public byte[] dealImageForIos(String bucketName, String fileId) {
        return this.dealImageForIos(bucketName, fileId, null);
    }

    @Override
    public byte[] dealImageForIos(String fileId) {
        return this.dealImageForIos(null, fileId, null);
    }

    /**
     * 获取所有缓存
     *
     * @param bucketName 存储区
     * @return List<ImageCacheFile>
     */
    @Override
    public List<ImageCacheFile> findImageCacheFiles(String bucketName) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/imageCacheFiles";
        Map<String, String> headers = HttpUtils.setHeader();
        List imageCacheFiles = HttpRequestUtil.get(handleImageUrl, headers, ArrayList.class);
        List<ImageCacheFile> imageCacheFileList = new ArrayList<>();
        if (null == imageCacheFiles) {
            return null;
        } else {
            for (Object imageCacheFile : imageCacheFiles) {
                try {
                    String json = ObjectMapperUtil.writeValueAsString(imageCacheFile);
                    ImageCacheFile cacheFile = ObjectMapperUtil.readValue(json, ImageCacheFile.class);
                    imageCacheFileList.add(cacheFile);
                } catch (IOException e) {
                    throw new OperateException(e);
                }
            }
            return imageCacheFileList;
        }
    }

    @Override
    public List<ImageCacheFile> findImageCacheFiles() {
        return this.findImageCacheFiles(null);
    }

    /**
     * 清除缓存
     *
     * @param bucketName 存储区
     */
    @Override
    public void clean(String bucketName) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/imageCacheFilesClean";
        Map<String, String> headers = HttpUtils.setHeader();
        HttpRequestUtil.delete(handleImageUrl, headers, null);
    }

    @Override
    public void clean() {
        this.clean(null);
    }

    private static class Holder { // lazy class
        static final IHandleImageService instance = new HandleImageService();
    }

}
