package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

/**
 * 普通上传
 * /api/dmc/v1/buckets/{bucket}/files
 *
 * @author chenzwd
 * @date : 2018-06-30 16:04
 */
public class GeneralDocumentUploader implements IGeneralDocumentUploader {

    private String discardTenantId;
    private String bucketName;
    private FileInfo fileInfo;
    private String driveToken;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();

    private GeneralDocumentUploader(String discardTenantId, String bucketName, FileInfo fileInfo, String driveToken) {
        this.discardTenantId = discardTenantId;
        this.bucketName = bucketName;
        this.fileInfo = fileInfo;
        this.driveToken = driveToken;
    }

    public GeneralDocumentUploader(String discardTenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        this(discardTenantId, bucketName, fileInfo, driveToken);
        try {
            this.inputStream = Files.newInputStream(Paths.get(localPath));
        } catch (IOException e) {
            throw new OperateException(e);
        }
    }

    public GeneralDocumentUploader(String discardTenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        this(discardTenantId, bucketName, fileInfo, driveToken);
        this.inputStream = new ByteArrayInputStream(bytes);
    }

    /**
     * 上传Stream中的文件内容
     */
    @Override
    public IGeneralDocumentUploader upload() {
        try {
            bucketName = ArgumentUtils.getBucketName(bucketName);
            String uri = String.format("%s/api/dmc/v1/buckets/%s/files", ServerSetting.getServiceUrl(), bucketName);
            Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, fileInfo);

            Runnable runnable = () -> {
                Map<String, String> result = HttpRequestUtil.uploadFile(uri, headers, inputStream, HashMap.class);
                String fileId = result.get("id");
                if (completeCallback != null) {
                    eventArgs.setFileId(fileId);
                    eventArgs.setPercentage(1);
                    completeCallback.callback(eventArgs);
                }
            };
            ExecutorUtil.newExecutor().execute(runnable);
            return this;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }


    /**
     * 设置完成
     */
    @Override
    public IGeneralDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}
