package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

/**
 * 分享并上传
 * /api/dmc/v1/buckets/{bucket}/shareUploudFile
 *
 * @date 2022/6/7 13:52
 */
public class ShareUploader implements IShareUploader {

    private String bucketName;
    private FileInfo fileInfo;
    private String driveToken;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();

    private ShareUploader(String bucketName, FileInfo fileInfo, String driveToken) {
        this.bucketName = bucketName;
        this.fileInfo = fileInfo;
        this.driveToken = driveToken;
    }

    public ShareUploader(String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        this(bucketName, fileInfo, driveToken);
        try {
            this.inputStream = Files.newInputStream(Paths.get(localPath));
        } catch (IOException e) {
            throw new OperateException(e);
        }
    }

    public ShareUploader(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        this(bucketName, fileInfo, driveToken);
        this.inputStream = new ByteArrayInputStream(bytes);
    }

    /**
     * 上传Stream中的文件内容，同步模式
     *
     * @return
     */
    @Override
    public IShareUploader upload() {
        try {
            bucketName = ArgumentUtils.getBucketName(bucketName);
            String uri = String.format("%s/api/dmc/v1/buckets/%s/shareUploudFile", ServerSetting.getServiceUrl(), bucketName);
            Map<String, String> headers = HttpUtils.setHeader(driveToken, null, fileInfo);

            Runnable runnable = () -> {
                Map<String, String> result = HttpRequestUtil.uploadFile(uri, headers, inputStream, HashMap.class);
                String fileId = null;
                String url = null;
                if (result != null) {
                    fileId = result.get("fileId");
                    url = result.get("url");
                }
                if (completeCallback != null) {
                    eventArgs.setFileId(fileId);
                    eventArgs.setUrl(url);
                    eventArgs.setPercentage(1);
                    completeCallback.callback(eventArgs);
                }
            };
            ExecutorUtil.newExecutor().execute(runnable);
            return this;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /**
     * 设置完成
     */
    @Override
    public IShareUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}
