package com.digiwin.dmc.sdk.util;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.dmc.internal.DMCConstants;
import com.digiwin.dap.middleware.dmc.internal.DMCHeaders;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.fasterxml.jackson.core.JsonProcessingException;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

/**
 * http headers请求封装
 *
 * @author fobgo
 * @date 2022/6/7 17:26
 */
public class HttpUtils {

    private static final IUserManagerService userManagerService = UserManagerService.userInstance();

    public static Map<String, String> setHeader() {
        return setHeader(null);
    }

    public static Map<String, String> setHeader(String driveToken, TenantId... tenantId) {
        return setHeader(driveToken, null, tenantId);
    }

    public static Map<String, String> setHeader(String driveToken, String discardTenantId, TenantId... tenantId) {
        return setHeader(driveToken, discardTenantId, null, tenantId);
    }

    /**
     * 设置请求token
     *
     * @param driveToken      授权token，基本上没人用(也建议不要使用)
     * @param discardTenantId 旧版本多租户方案(过时，不再使用)
     * @param fileInfo        文件信息(上传文件)
     * @param tenantId        租户ID
     */
    public static Map<String, String> setHeader(String driveToken, String discardTenantId, FileInfo fileInfo, TenantId... tenantId) {
        Map<String, String> headers = new HashMap<>();
        if (StringUtil.isEmpty(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(DMCHeaders.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        } else {
            headers.put(DMCHeaders.HTTP_HEADER_DRIVE_TOKEN_KEY, driveToken);
        }
        if (!StringUtil.isEmpty(discardTenantId)) {
            headers.put(DMCHeaders.HTTP_HEADER_TENANT_ID_KEY, discardTenantId);
        }
        if (fileInfo != null) {
            try {
                headers.put(DMCHeaders.HTTP_HEADER_API_ARG_KEY, URLEncoder.encode(ObjectMapperUtil.writeValueAsString(fileInfo), StandardCharsets.UTF_8.name()));
            } catch (UnsupportedEncodingException | JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        String finalTenantId = TenantId.getId(fileInfo, tenantId);
        if (finalTenantId != null) {
            headers.put(DMCHeaders.HTTP_HEADER_ACCESS_TOKEN_KEY, DMCConstants.DMC_SDK + finalTenantId);
        }
        setHeaderApp(headers);
        return headers;
    }

    public static Map<String, String> setHeaderAdmin() {
        return setHeaderAdmin(null);
    }

    public static Map<String, String> setHeaderAdmin(String discardTenantId) {
        Map<String, String> headers = new HashMap<>();
        String userToken = userManagerService.getUserToken(ServerSetting.getAdmin());
        headers.put(DMCHeaders.HTTP_HEADER_USER_TOKEN_KEY, userToken);
        if (!StringUtil.isEmpty(discardTenantId)) {
            headers.put(DMCHeaders.HTTP_HEADER_TENANT_ID_KEY, discardTenantId);
        }
        String finalTenantId = TenantId.getId(null);
        if (finalTenantId != null) {
            headers.put(DMCHeaders.HTTP_HEADER_ACCESS_TOKEN_KEY, DMCConstants.DMC_SDK + finalTenantId);
        }
        setHeaderApp(headers);
        return headers;
    }

    public static Map<String, String> setHeaderApp() {
        Map<String, String> headers = new HashMap<>();
        setHeaderApp(headers);
        return headers;
    }

    public static void setHeaderApp(Map<String, String> headers) {
        headers.put(DMCHeaders.HTTP_HEADER_APP_TOKEN_KEY, ServerSetting.getAppToken());
        headers.put(DMCHeaders.HTTP_HEADER_APP_SECRET, ServerSetting.getAppSecret());
    }
}
