package com.digiwin.dmc.sdk.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;

import java.util.Calendar;
import java.util.Date;

/**
 * 检查token是否过期
 *
 * @author chenxsa
 * @date 2018-6-6 15:27
 */
public class JwtUtil {

    /**
     * 校验token是否过期
     *
     * @param token 密钥
     * @return 是否正确
     */
    public static boolean isExpires(String token) {
        try {
            DecodedJWT jwt = JWT.decode(token);
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(Calendar.SECOND, 30);
            return cal.getTime().after(jwt.getExpiresAt());
        } catch (Exception exception) {
            return true;
        }
    }
}
