package com.digiwin.dmc.sdk.util;

/**
 * StringUtil
 *
 * @author chenxsa
 */
public class StringUtil {

    private final static String COLON = ".";

    /**
     * 首字母大写
     *
     * @param str 目标
     * @return
     */
    public static String upperCase(String str) {
        if (isEmpty(str)) {
            return str;
        }
        char[] ch = str.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char) (ch[0] - 32);
        }
        return new String(ch);
    }

    public static boolean isEmpty(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        return false;
    }

    /**
     * 判断2个string想等
     *
     * @param str1
     * @param str2
     * @return 同时为空或者想等返回true
     */
    public static boolean equals(String str1, String str2) {
        if (isEmpty(str1) && isEmpty(str2)) {
            return true;
        }
        if (isEmpty(str1) && !isEmpty(str2)) {
            return false;
        }
        if (!isEmpty(str1) && isEmpty(str2)) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean checkSpecialId(String id) {
        if (id == null || id.length() == 0) {
            return true;
        }
        if (id.contains(COLON)) {
            return true;
        }
        return false;
    }
}
