/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.utils;

import com.digiwin.dap.middleware.dmc.ClientException;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.model.StdError;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;

public class ExceptionFactory {
    public static ClientException createNetworkException(IOException ex) {
        Throwable cause;
        String requestId = "Unknown";
        String errorCode = "Unknown";
        if (ex instanceof SocketTimeoutException) {
            errorCode = "SocketTimeout";
        } else if (ex instanceof SocketException) {
            errorCode = "SocketException";
        } else if (ex instanceof ConnectTimeoutException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof UnknownHostException) {
            errorCode = "UnknownHost";
        } else if (ex instanceof HttpHostConnectException) {
            errorCode = "ConnectionRefused";
        } else if (ex instanceof NoHttpResponseException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof ClientProtocolException && (cause = ex.getCause()) instanceof NonRepeatableRequestException) {
            errorCode = "NonRepeatableRequest";
            return new ClientException(cause.getMessage(), errorCode, requestId, cause);
        }
        return new ClientException(ex.getMessage(), errorCode, requestId, ex);
    }

    public static DMCException createInvalidResponseException(String requestId, String rawResponseError, Throwable cause) {
        return ExceptionFactory.createInvalidResponseException(requestId, DMCUtils.COMMON_RESOURCE_MANAGER.getFormattedString("FailedToParseResponse", cause.getMessage()), rawResponseError);
    }

    public static DMCException createInvalidResponseException(String requestId, String message, String rawResponseError) {
        return ExceptionFactory.createDMCException(requestId, "InvalidResponse", message, rawResponseError);
    }

    public static DMCException createDMCException(String requestId, String errorCode, String message, String rawResponseError) {
        return new DMCException(message, errorCode, requestId, null, null, null, null, rawResponseError);
    }

    public static DMCException createDMCException(String requestId, String errorCode, String message) {
        return new DMCException(message, errorCode, requestId, null, null, null, null);
    }

    public static DMCException createUnknownDMCException(String requestId, int statusCode) {
        String message = "No body in response, http status code " + statusCode;
        return new DMCException(message, "Unknown", requestId, null, null, null, null);
    }

    public static DMCException createDMCException(StdError errorResult) {
        return new DMCException(String.format("%s\uff1a%s", errorResult.getErrorMessage(), errorResult.getMessage()), errorResult.getErrorCode());
    }
}

