/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.event;

import com.digiwin.dap.middleware.dmc.event.ProgressListener;
import com.digiwin.dap.middleware.dmc.event.RequestProgressInputStream;
import com.digiwin.dap.middleware.dmc.event.ResponseProgressInputStream;
import com.digiwin.dap.middleware.dmc.internal.model.WebServiceRequest;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ProgressInputStream
extends FilterInputStream {
    private static final int DEFAULT_NOTIFICATION_THRESHOLD = 8192;
    private final ProgressListener listener;
    private final int notifyThreshold;
    private int unNotifiedByteCount;
    private boolean hasBeenRead;
    private boolean doneEOF;
    private long notifiedByteCount;

    public static InputStream inputStreamForRequest(InputStream is, WebServiceRequest req) {
        return req == null ? is : new RequestProgressInputStream(is, req.getProgressListener());
    }

    public static InputStream inputStreamForResponse(InputStream is, WebServiceRequest req) {
        return req == null ? is : new ResponseProgressInputStream(is, req.getProgressListener());
    }

    public ProgressInputStream(InputStream is, ProgressListener listener) {
        this(is, listener, 8192);
    }

    public ProgressInputStream(InputStream is, ProgressListener listener, int notifyThreshold) {
        super(is);
        if (is == null || listener == null) {
            throw new IllegalArgumentException();
        }
        this.listener = listener;
        this.notifyThreshold = notifyThreshold;
    }

    protected void onFirstRead() {
    }

    protected void onEOF() {
    }

    protected void onClose() {
        this.eof();
    }

    protected void onReset() {
    }

    protected void onNotifyBytesRead() {
    }

    private void onBytesRead(int bytesRead) {
        this.unNotifiedByteCount += bytesRead;
        if (this.unNotifiedByteCount >= this.notifyThreshold) {
            this.onNotifyBytesRead();
            this.notifiedByteCount += (long)this.unNotifiedByteCount;
            this.unNotifiedByteCount = 0;
        }
    }

    @Override
    public int read() throws IOException {
        int ch;
        if (!this.hasBeenRead) {
            this.onFirstRead();
            this.hasBeenRead = true;
        }
        if ((ch = super.read()) == -1) {
            this.eof();
        } else {
            this.onBytesRead(1);
        }
        return ch;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.onReset();
        this.unNotifiedByteCount = 0;
        this.notifiedByteCount = 0L;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (!this.hasBeenRead) {
            this.onFirstRead();
            this.hasBeenRead = true;
        }
        if ((bytesRead = super.read(b, off, len)) == -1) {
            this.eof();
        } else {
            this.onBytesRead(bytesRead);
        }
        return bytesRead;
    }

    private void eof() {
        if (this.doneEOF) {
            return;
        }
        this.onEOF();
        this.unNotifiedByteCount = 0;
        this.doneEOF = true;
    }

    public final InputStream getWrappedInputStream() {
        return this.in;
    }

    protected final int getUnNotifiedByteCount() {
        return this.unNotifiedByteCount;
    }

    protected final long getNotifiedByteCount() {
        return this.notifiedByteCount;
    }

    @Override
    public void close() throws IOException {
        this.onClose();
        super.close();
    }

    public final ProgressListener getListener() {
        return this.listener;
    }
}

