/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.internal.DMCLogin;
import java.net.URI;

public class DMCConfig
extends DMCLogin {
    private static final String LOGIN = "%s/api/dmc/v1/auth/login";
    private static final String REFRESH = "%s/api/dmc/v1/auth/token/refresh";
    private static final String UPLOAD = "%s/api/dmc/v2/file/%s/upload";
    private static final String UPLOAD_COVER = "%s/api/dmc/v2/file/%s/upload/cover";
    private static final String UPLOAD_MULTI = "%s/api/dmc/v2/file/%s/upload/multi";
    private static final String UPLOAD_EMPTY = "%s/api/dmc/v1/buckets/%s/files/segment";
    private static final String UPLOAD_MULTIPART = "%s/api/dmc/v1/buckets/%s/files/%s/%s/%s/%s";
    private static final String DOWNLOAD = "%s/api/dmc/v2/file/%s/download/%s";
    private static final String DOWNLOAD_MULTI = "%s/api/dmc/v2/file/%s/download/multi";
    private static final String DELETE = "%s/api/dmc/v2/file/%s/delete/%s";
    private static final String DELETE_MULTI = "%s/api/dmc/v2/file/%s/delete";
    private static final String DELETE_FORCE = "%s/api/dmc/v2/file/%s/delete/force/%s";
    private static final String DELETE_FORCE_MULTI = "%s/api/dmc/v2/file/%s/delete/force";
    private static final String RECYCLE = "%s/api/dmc/v2/file/%s/recycle/delete/%s";
    private static final String RECYCLE_MULTI = "%s/api/dmc/v2/file/%s/recycle/delete";
    private static final String RECYCLE_CLEAR = "%s/api/dmc/v2/file/%s/recycle/clear";
    private static final String RECYCLE_RESTORE = "%s/api/dmc/v2/file/%s/recycle/restore/%s";
    private static final String RECYCLE_RESTORE_MULTI = "%s/api/dmc/v2/file/%s/recycle/restore";
    private static final String COPY = "%s/api/dmc/v2/file/%s/copy/%s/%s";
    private static final String COPY_DIR = "%s/api/dmc/v2/file/%s/copy/dir/%s/%s";
    private static final String COPY_MULTI = "%s/api/dmc/v2/file/%s/copy/%s";
    private static final String MOVE = "%s/api/dmc/v2/file/%s/move/%s/%s";
    private static final String MOVE_DIR = "%s/api/dmc/v2/file/%s/move/dir/%s/%s";
    private static final String MOVE_MULTI = "%s/api/dmc/v2/file/%s/move/%s";
    private static final String SHARE_MULTI = "%s/api/dmc/v2/file/%s/share";
    private static final String SHARE_DELETE_MULTI = "%s/api/dmc/v2/file/%s/share/delete";
    private static final String IMAGE_UPLOAD = "%s/api/dmc/v1/buckets/%s/images/upload?shrink=1&width=%s&height=%s";
    private static final String IMAGE_SHRINK = "%s/api/dmc/v1/buckets/%s/images/%s?shrink=1&width=%s&height=%s&share=%s";
    private static final String IMAGE = "%s/api/dmc/v1/buckets/%s/images/%s/%s";
    private static final String DIR_ADD = "%s/api/dmc/v2/directory/%s";
    private static final String DIR_MOD = "%s/api/dmc/v2/directory/%s";
    private static final String DIR_GET = "%s/api/dmc/v2/directory/%s/%s";
    private static final String DIR_GET_BY_NAME = "%s/api/dmc/v1/buckets/%s/directorys/%s/%s";
    private static final String FILE_MOD = "%s/api/dmc/v2/fileinfo/%s";
    private static final String FILE_GET = "%s/api/dmc/v2/fileinfo/%s/%s";
    private static final String FILES_GET_BY_DIR_ID = "%s/api/dmc/v2/fileinfo/%s/directory/%s";
    private static final String FILES_GET_BY_IDS = "%s/api/dmc/v2/fileinfo/%s/ids";

    public URI getLoginUrl() {
        return URI.create(String.format(LOGIN, this.uri));
    }

    public URI getRefreshUrl() {
        return URI.create(String.format(REFRESH, this.uri));
    }

    public URI getUploadUrl() {
        return URI.create(String.format(UPLOAD, this.uri, this.bucket));
    }

    public URI getUploadCoverUrl() {
        return URI.create(String.format(UPLOAD_COVER, this.uri, this.bucket));
    }

    public URI getUploadMultiUrl() {
        return URI.create(String.format(UPLOAD_MULTI, this.uri, this.bucket));
    }

    public URI getUploadEmptyUrl() {
        return URI.create(String.format(UPLOAD_EMPTY, this.uri, this.bucket));
    }

    public URI getUploadMultipartUrl(String fileId, long from, long to, long total) {
        return URI.create(String.format(UPLOAD_MULTIPART, this.uri, this.bucket, fileId, from, to, total));
    }

    public URI getDownloadUrl(String fileId) {
        return URI.create(String.format(DOWNLOAD, this.uri, this.bucket, fileId));
    }

    public URI getDownloadMultiUrl() {
        return URI.create(String.format(DOWNLOAD_MULTI, this.uri, this.bucket));
    }

    public URI getDeleteUrl(String fileId) {
        return URI.create(String.format(DELETE, this.uri, this.bucket, fileId));
    }

    public URI getDeleteMultiUrl() {
        return URI.create(String.format(DELETE_MULTI, this.uri, this.bucket));
    }

    public URI getDeleteForceUrl(String fileId) {
        return URI.create(String.format(DELETE_FORCE, this.uri, this.bucket, fileId));
    }

    public URI getDeleteForceMultiUrl() {
        return URI.create(String.format(DELETE_FORCE_MULTI, this.uri, this.bucket));
    }

    public URI getRecycleUrl(String recycleId) {
        return URI.create(String.format(RECYCLE, this.uri, this.bucket, recycleId));
    }

    public URI getRecycleMultiUrl() {
        return URI.create(String.format(RECYCLE_MULTI, this.uri, this.bucket));
    }

    public URI getRecycleClearUrl() {
        return URI.create(String.format(RECYCLE_CLEAR, this.uri, this.bucket));
    }

    public URI getRecycleRestoreUrl(String recycleId) {
        return URI.create(String.format(RECYCLE_RESTORE, this.uri, this.bucket, recycleId));
    }

    public URI getRecycleRestoreMultiUrl() {
        return URI.create(String.format(RECYCLE_RESTORE_MULTI, this.uri, this.bucket));
    }

    public URI getCopyUrl(String fileId, String targetDirId) {
        return URI.create(String.format(COPY, this.uri, this.bucket, fileId, targetDirId));
    }

    public URI getCopyDirUrl(String dirId, String targetDirId) {
        return URI.create(String.format(COPY_DIR, this.uri, this.bucket, dirId, targetDirId));
    }

    public URI getCopyMultiUrl(String targetDirId) {
        return URI.create(String.format(COPY_MULTI, this.uri, this.bucket, targetDirId));
    }

    public URI getMoveUrl(String fileId, String targetDirId) {
        return URI.create(String.format(MOVE, this.uri, this.bucket, fileId, targetDirId));
    }

    public URI getMoveDirUrl(String dirId, String targetDirId) {
        return URI.create(String.format(MOVE_DIR, this.uri, this.bucket, dirId, targetDirId));
    }

    public URI getMoveMultiUrl(String targetDirId) {
        return URI.create(String.format(MOVE_MULTI, this.uri, this.bucket, targetDirId));
    }

    public URI getShareMultiUrl() {
        return URI.create(String.format(SHARE_MULTI, this.uri, this.bucket));
    }

    public URI getShareDeleteMultiUrl() {
        return URI.create(String.format(SHARE_DELETE_MULTI, this.uri, this.bucket));
    }

    public URI getImageUploadUrl(int width, int height) {
        return URI.create(String.format(IMAGE_UPLOAD, this.uri, this.bucket, width, height));
    }

    public URI getImageShrinkUrl(String fileId, int width, int height, boolean share) {
        return URI.create(String.format(IMAGE_SHRINK, this.uri, this.bucket, fileId, width, height, share));
    }

    public URI getImageUrl(String fileId, boolean shrink) {
        return URI.create(String.format(IMAGE, this.uri, this.bucket, fileId, shrink));
    }

    public URI getDirInfoAddUrl() {
        return URI.create(String.format("%s/api/dmc/v2/directory/%s", this.uri, this.bucket));
    }

    public URI getDirInfoModUrl() {
        return URI.create(String.format("%s/api/dmc/v2/directory/%s", this.uri, this.bucket));
    }

    public URI getDirInfoGetUrl(String dirId) {
        return URI.create(String.format(DIR_GET, this.uri, this.bucket, dirId));
    }

    public URI getDirInfoGetByNameUrl(String parentDirId, String dirName) {
        return URI.create(String.format(DIR_GET_BY_NAME, this.uri, this.bucket, parentDirId, dirName));
    }

    public URI getFileInfoModUrl() {
        return URI.create(String.format(FILE_MOD, this.uri, this.bucket));
    }

    public URI getFileInfoGetUrl(String fileId) {
        return URI.create(String.format(FILE_GET, this.uri, this.bucket, fileId));
    }

    public URI getFileInfosGetUrl(String dirId) {
        return URI.create(String.format(FILES_GET_BY_DIR_ID, this.uri, this.bucket, dirId));
    }

    public URI getFileInfosGetUrl() {
        return URI.create(String.format(FILES_GET_BY_IDS, this.uri, this.bucket));
    }
}

