/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.util.AESCipher;

public final class DMCConfigBuilder {
    private String uri = ServerSetting.getServiceUrl();
    private String bucket = ServerSetting.getBucketName();
    private String username = ServerSetting.getIdentityName();
    private String password = ServerSetting.getIdentityPwd();
    private String tenantId = "default";
    private boolean lazy;
    private String appToken = ServerSetting.getAppToken();
    private String appSecret = ServerSetting.getAppSecret();

    private DMCConfigBuilder() {
    }

    public static DMCConfigBuilder create() {
        return new DMCConfigBuilder();
    }

    public static DMCConfigBuilder create(String uri, String username, String password, String bucket) {
        return DMCConfigBuilder.create().uri(uri).username(username).password(password).bucket(bucket);
    }

    public DMCConfigBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public DMCConfigBuilder bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public DMCConfigBuilder username(String username) {
        this.username = username;
        return this;
    }

    public DMCConfigBuilder password(String password) {
        this.password = password;
        return this;
    }

    public DMCConfigBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public DMCConfigBuilder lazy(boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    public DMCConfigBuilder appToken(String appToken) {
        this.appToken = appToken;
        return this;
    }

    public DMCConfigBuilder appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public DMCConfig build() {
        DMCConfig config = new DMCConfig();
        config.setUri(this.uri);
        config.setBucket(this.bucket);
        config.setUsername(this.username);
        config.setPassword(this.password);
        if (this.password != null) {
            config.setPwdhash(AESCipher.getSHA256StrJava(this.password));
        }
        config.setTenantId(this.tenantId);
        config.setLazy(this.lazy);
        config.setAppToken(this.appToken);
        config.setAppSecret(this.appSecret);
        return config;
    }
}

