/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;

public class DMCLogin {
    protected String uri;
    protected String bucket;
    private String username;
    private String password;
    private String pwdhash;
    private String tenantId = "default";
    private boolean lazy;
    private String appToken;
    private String appSecret;

    public static void check(DMCLogin config) {
        if (config == null) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getString("dmc.sdk.config.null"));
        }
        if (config.getUri() == null) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getString("dmc.sdk.config.uri.null"));
        }
        if (config.getBucket() == null) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getString("dmc.sdk.config.bucket.null"));
        }
        if (config.getUsername() == null) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getString("dmc.sdk.config.username.null"));
        }
        if (config.getPwdhash() == null) {
            throw new DMCException(DMCUtils.DMC_RESOURCE_MANAGER.getString("dmc.sdk.config.password.null"));
        }
    }

    public static String uniqueKey(String username, String tenantId) {
        return String.format("%s::%s", username, tenantId == null ? "default" : tenantId);
    }

    public String uniqueKey() {
        return DMCLogin.uniqueKey(this.username, this.tenantId);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPwdhash() {
        return this.pwdhash;
    }

    public void setPwdhash(String pwdhash) {
        this.pwdhash = pwdhash;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }
}

