/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.ClientException;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.ServiceException;
import com.digiwin.dap.middleware.dmc.common.comm.ExecutionContext;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ResponseHandler;
import com.digiwin.dap.middleware.dmc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.dmc.common.parser.ResponseParser;
import com.digiwin.dap.middleware.dmc.common.utils.ExceptionFactory;
import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.ErrorResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DMCOperation {
    protected static final Logger logger = LoggerFactory.getLogger(DMCOperation.class);
    protected static ResponseHandler errorResponseHandler = new ErrorResponseHandler();
    protected ServiceClient client;
    protected DMCConfig config;

    protected DMCOperation(ServiceClient client) {
        this.client = client;
        this.config = client.getConfig();
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser) {
        return this.doOperation(request, parser, true);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, boolean keepResponseOpen) {
        ExecutionContext context = this.createDefaultContext();
        ResponseMessage response = this.send(request, context, keepResponseOpen);
        try {
            return parser.parse(response);
        }
        catch (ResponseParseException rpe) {
            DMCException de = ExceptionFactory.createInvalidResponseException(response.getRequestId(), rpe.getMessage(), rpe);
            logger.error("Unable to parse response error: ", (Throwable)rpe);
            throw de;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseMessage send(RequestMessage request, ExecutionContext context, boolean keepResponseOpen) throws ServiceException, ClientException {
        ResponseMessage response = null;
        try {
            ResponseMessage responseMessage = response = this.client.sendRequest(request, context);
            return responseMessage;
        }
        finally {
            if (response != null && !keepResponseOpen) {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    protected ExecutionContext createDefaultContext() {
        ExecutionContext context = new ExecutionContext();
        context.addResponseHandler(errorResponseHandler);
        return context;
    }
}

