/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.DirInfo;
import com.digiwin.dap.middleware.dmc.model.DirRequest;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfoRequest;
import com.digiwin.dap.middleware.dmc.model.FileInfosRequest;
import java.util.List;

public class DMCBaseOperation
extends DMCOperation {
    public DMCBaseOperation(ServiceClient client) {
        super(client);
    }

    public DirInfo addDirInfo(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDirInfoAddUrl()).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.dirInfoResponseParser);
    }

    public DirInfo modDirInfo(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDirInfoModUrl()).setMethod(HttpMethod.PUT).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.dirInfoResponseParser);
    }

    public DirInfo getDirInfo(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDirInfoGetUrl(original.getDirId())).setMethod(HttpMethod.GET).setHeaders(original.getHeaders()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.dirInfoResponseParser);
    }

    public DirInfo getDirInfoByName(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDirInfoGetByNameUrl(original.getDirInfo().getParentId(), original.getDirInfo().getName())).setMethod(HttpMethod.GET).setHeaders(original.getHeaders()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.dirInfoResponseParser);
    }

    public FileInfo modFileInfo(FileInfoRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getFileInfoModUrl()).setMethod(HttpMethod.PUT).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.fileInfoResponseParser);
    }

    public FileInfo getFileInfo(FileInfoRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getFileInfoGetUrl(original.getFileId())).setMethod(HttpMethod.GET).setHeaders(original.getHeaders()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.fileInfoResponseParser);
    }

    public List<FileInfo> getFileInfoByDirId(FileInfosRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getFileInfosGetUrl(original.getDirId())).setMethod(HttpMethod.GET).setHeaders(original.getHeaders()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.fileInfosResponseParser);
    }

    public List<FileInfo> getFileInfoByIds(FileInfosRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getFileInfosGetUrl()).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.fileInfosResponseParser);
    }
}

