/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.event.ProgressEventType;
import com.digiwin.dap.middleware.dmc.event.ProgressListener;
import com.digiwin.dap.middleware.dmc.event.ProgressPublisher;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfoRequest;
import com.digiwin.dap.middleware.dmc.model.MultipartUploadRequest;
import com.digiwin.dap.middleware.dmc.model.PartUploader;
import com.digiwin.dap.middleware.dmc.model.UploadCoverRequest;
import com.digiwin.dap.middleware.dmc.model.UploadMultiRequest;
import com.digiwin.dap.middleware.dmc.model.UploadRequest;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;

public class DMCUploadOperation
extends DMCOperation {
    public DMCUploadOperation(ServiceClient client) {
        super(client);
    }

    public FileInfo upload(UploadRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadUrl()).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.uploadResponseParser, true);
    }

    public FileInfo coverUpload(UploadCoverRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadCoverUrl()).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.uploadResponseParser, true);
    }

    public List<FileInfo> uploadMulti(UploadMultiRequest original) throws Exception {
        RequestMessage requestMessage = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadMultiUrl()).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setOriginalRequest(original).build();
        return this.doOperation(requestMessage, ResponseParsers.uploadMultiResponseParser);
    }

    public String multipartUpload(MultipartUploadRequest request) throws Exception {
        ProgressListener listener;
        String fileId;
        block34: {
            long partSize = request.getPartSize();
            if (partSize % 261120L != 0L) {
                throw new DMCException("\u5206\u6bb5\u5927\u5c0f\u8bf7\u8bbe\u7f6e261120\u7684\u6574\u6570\u500d");
            }
            fileId = this.claimFileId(request.getFileInfo());
            logger.info("Claiming a new file id {}.", (Object)fileId);
            long fileLength = request.getFileLength();
            int partCount = (int)(fileLength / partSize);
            if (fileLength % partSize != 0L) {
                ++partCount;
            }
            if (partCount > 10000) {
                throw new DMCException("\u5206\u6bb5\u603b\u6570\u4e0d\u80fd\u8d85\u8fc710000");
            }
            logger.info("Total parts count {}.", (Object)partCount);
            listener = request.getProgressListener();
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_STARTED_EVENT);
            ProgressPublisher.publishRequestContentLength(listener, fileLength);
            if (request.getInput() != null) {
                try (InputStream inputStream = request.getInput();){
                    for (int i = 0; i < partCount; ++i) {
                        long startPos = (long)i * partSize;
                        int curPartSize = (int)(i + 1 == partCount ? fileLength - startPos : partSize);
                        inputStream.skip(startPos);
                        byte[] buffer = new byte[curPartSize];
                        inputStream.read(buffer);
                        this.uploadPart(fileId, buffer, startPos, curPartSize, fileLength, partCount, i + 1, listener);
                    }
                    break block34;
                }
                catch (Exception e) {
                    ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
                    throw e;
                }
            }
            try (FileChannel channel = new RandomAccessFile(request.getFile(), "r").getChannel();){
                MappedByteBuffer map = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
                for (int i = 0; i < partCount; ++i) {
                    long startPos = (long)i * partSize;
                    int curPartSize = (int)(i + 1 == partCount ? fileLength - startPos : partSize);
                    byte[] buffer = new byte[curPartSize];
                    map.get(buffer, 0, curPartSize);
                    this.uploadPart(fileId, buffer, startPos, curPartSize, fileLength, partCount, i + 1, listener);
                }
            }
            catch (Exception e) {
                ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
                throw e;
            }
        }
        ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        return fileId;
    }

    private void uploadPart(String fileId, byte[] buffer, long startPos, int curPartSize, long fileLength, int partCount, int partNum, ProgressListener listener) throws Exception {
        PartUploader partUploader = new PartUploader();
        partUploader.setFileId(fileId);
        partUploader.setParts(buffer);
        partUploader.setFrom(startPos);
        partUploader.setTo(startPos + (long)curPartSize - 1L);
        partUploader.setTotal(fileLength);
        this.uploadPart(partUploader);
        ProgressPublisher.publishRequestBytesTransferred(listener, curPartSize);
        logger.info("\u603b\u5171\uff1a{}\u6bb5, \u7b2c{}\u6bb5\u4e0a\u4f20\u6210\u529f\uff1afileId={},startPos={},curPartSize={}.", new Object[]{partCount, partNum, fileId, startPos, curPartSize});
    }

    private void uploadPart(PartUploader original) throws Exception {
        RequestMessage requestMessage = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadMultipartUrl(original.getFileId(), original.getFrom(), original.getTo(), original.getTotal())).setMethod(HttpMethod.POST).setEntity(original.getEntity()).build();
        this.doOperation(requestMessage, ResponseParsers.uploadMultipartResponseParser);
    }

    private String claimFileId(FileInfo fileInfo) throws Exception {
        FileInfoRequest original = new FileInfoRequest();
        original.setFileInfo(fileInfo);
        RequestMessage requestMessage = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadEmptyUrl()).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setOriginalRequest(original).build();
        return this.doOperation(requestMessage, ResponseParsers.uploadMultipartResponseParser);
    }
}

