/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dmc.sdk.util.JsonUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class UploadRequest
extends GenericRequest {
    private File file;
    private byte[] bytes;
    private InputStream input;
    private FileInfo fileInfo;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public InputStream getInput() {
        return this.input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    @Override
    public HttpEntity getEntity() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (this.file != null) {
            builder.addBinaryBody("file", this.file);
        } else if (this.bytes != null) {
            builder.addBinaryBody("file", this.bytes, ContentType.DEFAULT_BINARY, this.fileInfo.getFileName());
        } else if (this.input != null) {
            builder.addBinaryBody("file", this.input, ContentType.DEFAULT_BINARY, this.fileInfo.getFileName());
        }
        if (this.fileInfo != null) {
            builder.addTextBody("fileInfo", JsonUtils.writeValueAsString(this.fileInfo), ContentType.create((String)"application/json", (Charset)Consts.UTF_8));
        }
        return builder.build();
    }
}

