/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.identity;

import com.digiwin.dmc.sdk.util.AESCipher;
import java.util.Objects;

public class UserIdentity {
    private String tenantId;
    private String userName;
    private String password;
    private String passwordHash;

    public UserIdentity() {
    }

    public UserIdentity(String userName, String password) {
        this(userName, password, false);
    }

    public UserIdentity(String userName, String password, boolean hash) {
        this.userName = userName;
        if (hash) {
            this.password = password;
        } else {
            this.password = password;
            this.passwordHash = AESCipher.getSHA256StrJava(password);
        }
    }

    public static UserIdentity getUserIdentity(String userName, String password) {
        return new UserIdentity(userName, password);
    }

    public static UserIdentity getSecureUserIdentity(String userName, String passwordHash) {
        return new UserIdentity(userName, passwordHash, true);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String uniqueKey() {
        return String.format("%s::%s", this.userName, this.tenantId == null ? "default" : this.tenantId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserIdentity that = (UserIdentity)o;
        return Objects.equals(this.tenantId, that.tenantId) && this.userName.equals(that.userName);
    }

    public int hashCode() {
        return Objects.hash(this.tenantId, this.userName);
    }
}

