/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.download.DownloadProgressEventArgs;
import com.digiwin.dmc.sdk.service.download.IDownLoadCallbackable;
import com.digiwin.dmc.sdk.service.download.IGeneralDocumentDownloader;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;

public class GeneralDocumentDownloader
implements IGeneralDocumentDownloader {
    private String discardTenantId;
    private String bucketName;
    private String fileId;
    private String driveToken;
    private TenantId[] tenantId;
    private OutputStream outputStream;
    private IDownLoadCallbackable completeCallback;
    private DownloadProgressEventArgs eventArgs = new DownloadProgressEventArgs();

    private GeneralDocumentDownloader(String discardTenantId, String bucketName, String fileId, String driveToken, TenantId ... tenantId) {
        this.discardTenantId = discardTenantId;
        this.bucketName = bucketName;
        this.fileId = fileId;
        this.driveToken = driveToken;
        this.tenantId = tenantId;
    }

    public GeneralDocumentDownloader(String discardTenantId, String bucketName, String fileId, String saveToPath, String driveToken, TenantId ... tenantId) {
        this(discardTenantId, bucketName, fileId, driveToken, tenantId);
        try {
            this.outputStream = Files.newOutputStream(Paths.get(saveToPath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
    }

    @Override
    public IGeneralDocumentDownloader download() {
        this.bucketName = ArgumentUtils.getBucketName(this.bucketName);
        String uri = String.format("%s/api/dmc/v1/buckets/%s/files/%s", ServerSetting.getServiceUrl(), this.bucketName, this.fileId);
        Map<String, String> headers = HttpUtils.setHeader(this.driveToken, this.discardTenantId, this.tenantId);
        Runnable runnable = () -> {
            HttpRequestUtil.downloadFile(uri, headers, this.outputStream);
            if (this.completeCallback != null) {
                this.eventArgs.setPercentage(1.0);
                this.completeCallback.callback(this.eventArgs);
            }
        };
        ExecutorUtil.newExecutor().execute(runnable);
        return this;
    }

    @Override
    public IGeneralDocumentDownloader onCompleted(IDownLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}

