/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.BucketInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IBucketManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BucketManagerService
implements IBucketManagerService {
    public static IBucketManagerService bucketInstance() {
        return Holder.instance;
    }

    @Override
    public String createBucket(BucketInfo bucketInfo) {
        return this.createBucketByTenant(null, bucketInfo);
    }

    @Override
    public String createBucketByTenant(String discardTenantId, BucketInfo bucketInfo) {
        if (bucketInfo == null) {
            throw new IllegalArgumentException("\u53c2\u6570bucketInfo is null");
        }
        if (StringUtil.checkSpecialId(bucketInfo.getName())) {
            throw new IllegalArgumentException("bucketName\u4e3a\u7a7a\u6216\u5305\u542b\u7279\u6b8a\u5b57\u7b26.\u53f7\uff01");
        }
        HashMap<String, String> bucketMap = new HashMap<String, String>();
        bucketMap.put("name", bucketInfo.getName());
        bucketMap.put("keytype", bucketInfo.getKeyType().toLowerCase());
        bucketMap.put("description", bucketInfo.getDescription());
        try {
            String uri = String.format("%s/api/dmc/v1/buckets", ServerSetting.getServiceUrl());
            Map<String, String> headers = HttpUtils.setHeader(null, discardTenantId, new TenantId[0]);
            Map responseEntity = HttpRequestUtil.postJson(uri, ObjectMapperUtil.writeValueAsString(bucketMap), headers, HashMap.class);
            if (responseEntity == null || !responseEntity.containsKey("id")) {
                return null;
            }
            return responseEntity.get("id").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public List<BucketInfo> getBuckets() {
        String uri = String.format("%s/api/dmc/v1/buckets", ServerSetting.getServiceUrl());
        Map<String, String> headers = HttpUtils.setHeader();
        List buckets = HttpRequestUtil.get(uri, headers, ArrayList.class);
        ArrayList<BucketInfo> bucketInfos = new ArrayList<BucketInfo>();
        if (buckets != null) {
            for (Object bucket : buckets) {
                try {
                    String json = ObjectMapperUtil.writeValueAsString(bucket);
                    BucketInfo bucketInfo = ObjectMapperUtil.readValue(json, BucketInfo.class);
                    bucketInfos.add(bucketInfo);
                }
                catch (IOException e) {
                    throw new OperateException(e);
                }
            }
        }
        return bucketInfos;
    }

    @Override
    public String isExistBucket(String bucketName) {
        return this.isExistBucketByTenant(null, bucketName);
    }

    @Override
    public String isExistBucketByTenant(String discardTenantId, String bucketName) {
        Map<String, String> headers;
        if (bucketName == null || "".equals(bucketName)) {
            throw new IllegalArgumentException("\u53c2\u6570bucketName is null");
        }
        String uri = String.format("%s/api/dmc/v1/buckets/%s/isExist", ServerSetting.getServiceUrl(), bucketName);
        Map isExist = HttpRequestUtil.get(uri, headers = HttpUtils.setHeaderAdmin(discardTenantId), HashMap.class);
        if (isExist == null || !isExist.containsKey("isExist")) {
            return null;
        }
        return isExist.get("isExist").toString();
    }

    private static class Holder {
        static final IBucketManagerService instance = new BucketManagerService();

        private Holder() {
        }
    }
}

