/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.DriveAuthItem;
import com.digiwin.dmc.sdk.entity.DriveAuthRequest;
import com.digiwin.dmc.sdk.entity.DriveAuthRequestAction;
import com.digiwin.dmc.sdk.entity.DriveAuthRequestObjectType;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IDriveTokenService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import com.digiwin.dmc.sdk.util.JwtUtil;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class DriveTokenServiceImpl
implements IDriveTokenService {
    private static final String EMPTY_OBJECT_ID_STR = "00000000-0000-0000-0000-000000000000";
    private final Map<Integer, String> cache = new HashMap<Integer, String>();

    public static IDriveTokenService instance() {
        return Holder.instance;
    }

    @Override
    public String getDriveToken(DriveAuthRequest authRequest) {
        String driveToken;
        if (authRequest == null) {
            throw new IllegalArgumentException("\u53c2\u6570\uff1aauthRequest is null");
        }
        int hashcode = authRequest.hashCode();
        if (this.cache.containsKey(hashcode) && !JwtUtil.isExpires(driveToken = this.cache.get(hashcode))) {
            return driveToken;
        }
        String tokenUrl = DmcUrl.getTokenResourceUrl();
        try {
            Map<String, String> headers = HttpUtils.setHeader();
            String json = ObjectMapperUtil.writeValueAsString(authRequest);
            HashMap responseEntity = HttpRequestUtil.postJson(tokenUrl, json, headers, HashMap.class);
            if (responseEntity == null || !responseEntity.containsKey("driveToken")) {
                this.cache.remove(hashcode);
                return null;
            }
            driveToken = responseEntity.get("driveToken").toString();
            this.cache.put(hashcode, driveToken);
            return driveToken;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    @Deprecated
    public String getDriveTokenByTenant(String tenantId, DriveAuthRequest authRequest) {
        String driveToken;
        if (authRequest == null) {
            throw new IllegalArgumentException("\u53c2\u6570\uff1aauthRequest is null");
        }
        int hashcode = authRequest.hashCode();
        if (this.cache.containsKey(hashcode) && !JwtUtil.isExpires(driveToken = this.cache.get(hashcode))) {
            return driveToken;
        }
        String tokenUrl = DmcUrl.getTokenResourceUrl();
        try {
            Map<String, String> headers = HttpUtils.setHeader(null, tenantId, new TenantId[0]);
            String json = ObjectMapperUtil.writeValueAsString(authRequest);
            HashMap responseEntity = HttpRequestUtil.postJson(tokenUrl, json, headers, HashMap.class);
            if (responseEntity == null || !responseEntity.containsKey("driveToken")) {
                this.cache.remove(hashcode);
                return null;
            }
            driveToken = responseEntity.get("driveToken").toString();
            this.cache.put(hashcode, driveToken);
            return driveToken;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String getDirWriteDriveToken(String dirId) {
        if (StringUtil.isEmpty(dirId)) {
            dirId = EMPTY_OBJECT_ID_STR;
        }
        return this.getDriveToken(dirId, DriveAuthRequestAction.Write, DriveAuthRequestObjectType.Directory);
    }

    @Override
    public String getDirReadDriveToken(String dirId) {
        if (StringUtil.isEmpty(dirId)) {
            dirId = EMPTY_OBJECT_ID_STR;
        }
        return this.getDriveToken(dirId, DriveAuthRequestAction.Read, DriveAuthRequestObjectType.Directory);
    }

    @Override
    public String getFileReadDriveToken(String fileId) {
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("fileId is null");
        }
        return this.getDriveToken(fileId, DriveAuthRequestAction.Read, DriveAuthRequestObjectType.File);
    }

    String getDriveToken(String id, DriveAuthRequestAction driveAuthRequestAction, DriveAuthRequestObjectType driveAuthRequestObjectType) {
        DriveAuthRequest driveAuthRequest = new DriveAuthRequest();
        DriveAuthItem driveAuthItem = new DriveAuthItem();
        driveAuthItem.setBucket(ServerSetting.getBucketName());
        driveAuthItem.setActionName(driveAuthRequestAction);
        driveAuthItem.setObjectType(driveAuthRequestObjectType);
        driveAuthItem.setObjectId(id);
        driveAuthRequest.getItems().add(driveAuthItem);
        return this.getDriveToken(driveAuthRequest);
    }

    @Override
    public String getFileWriteDriveToken(String fileId) {
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("fileId is null");
        }
        return this.getDriveToken(fileId, DriveAuthRequestAction.Write, DriveAuthRequestObjectType.File);
    }

    private static class Holder {
        static final IDriveTokenService instance = new DriveTokenServiceImpl();

        private Holder() {
        }
    }
}

