/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.upload.ICoverGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IUpLoadCallbackable;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class CoverGeneralDocumentUploader
implements ICoverGeneralDocumentUploader {
    private String bucketName;
    private String fileId;
    private String driveToken;
    private TenantId[] tenantId;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();

    private CoverGeneralDocumentUploader(String bucketName, String fileId, String driveToken, TenantId ... tenantId) {
        this.bucketName = bucketName;
        this.fileId = fileId;
        this.driveToken = driveToken;
        this.tenantId = tenantId;
    }

    public CoverGeneralDocumentUploader(String bucketName, String localPath, String fileId, String driveToken, TenantId ... tenantId) {
        this(bucketName, fileId, driveToken, tenantId);
        try {
            this.inputStream = Files.newInputStream(Paths.get(localPath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    public CoverGeneralDocumentUploader(String bucketName, byte[] bytes, String fileId, String driveToken, TenantId ... tenantId) {
        this(bucketName, fileId, driveToken, tenantId);
        this.inputStream = new ByteArrayInputStream(bytes);
    }

    @Override
    public ICoverGeneralDocumentUploader upload() {
        try {
            this.bucketName = ArgumentUtils.getBucketName(this.bucketName);
            String uri = String.format("%s/api/dmc/v1/buckets/%s/files/%s/cover", ServerSetting.getServiceUrl(), this.bucketName, this.fileId);
            Map<String, String> headers = HttpUtils.setHeader(this.driveToken, this.tenantId);
            Runnable runnable = () -> {
                HttpRequestUtil.uploadFile(uri, headers, this.inputStream, HashMap.class);
                if (this.completeCallback != null) {
                    this.eventArgs.setFileId(this.fileId);
                    this.eventArgs.setPercentage(1.0);
                    this.completeCallback.callback(this.eventArgs);
                }
            };
            ExecutorUtil.newExecutor().execute(runnable);
            return this;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public ICoverGeneralDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}

