/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.NetworkOptions;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.upload.ICoverSegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IUpLoadCallbackable;
import com.digiwin.dmc.sdk.service.upload.UploadProcessState;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;

public class CoverSegmentDocumentUploader
implements ICoverSegmentDocumentUploader {
    private String bucketName;
    private String fileId;
    private String driveToken;
    private TenantId[] tenantId;
    private int bufferSize = NetworkOptions.Default.getPackageSize();
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private IUpLoadCallbackable progressChangedCallback;
    private UploadProcessState state = UploadProcessState.NotStarted;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();

    private CoverSegmentDocumentUploader(String bucketName, String fileId, String driveToken, TenantId ... tenantId) {
        this.bucketName = bucketName;
        this.fileId = fileId;
        this.driveToken = driveToken;
        this.tenantId = tenantId;
    }

    public CoverSegmentDocumentUploader(String bucketName, String localPath, String fileId, String driveToken, TenantId ... tenantId) {
        this(bucketName, fileId, driveToken, tenantId);
        try {
            this.inputStream = Files.newInputStream(Paths.get(localPath, new String[0]), new OpenOption[0]);
            this.eventArgs.setTotalBytes(this.inputStream.available());
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
    }

    public CoverSegmentDocumentUploader(String bucketName, byte[] bytes, String fileId, String driveToken, TenantId ... tenantId) {
        this(bucketName, fileId, driveToken, tenantId);
        try {
            this.inputStream = new ByteArrayInputStream(bytes);
            this.eventArgs.setTotalBytes(this.inputStream.available());
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
    }

    @Override
    public ICoverSegmentDocumentUploader beginUpload() {
        if (this.state != UploadProcessState.NotStarted) {
            throw new OperateException("\u4e0a\u4f20\u5df2\u5f00\u59cb\uff0c\u65e0\u6cd5\u518d\u6b21\u542f\u52a8\u4e0b\u8f7d\uff0c\u8bf7\u5f00\u542f\u65b0\u7684\u4e0a\u4f20");
        }
        this.bucketName = ArgumentUtils.getBucketName(this.bucketName);
        this.continueUpload();
        Map<String, String> headers = HttpUtils.setHeader(this.driveToken, this.tenantId);
        Runnable runnable = () -> {
            byte[] buffer = new byte[this.bufferSize];
            int bytesReaded = 0;
            int totalBytes = this.eventArgs.getTotalBytes();
            while (bytesReaded < totalBytes) {
                try {
                    bytesReaded = this.eventArgs.getCompletedBytes();
                    if (this.state == UploadProcessState.Stopped) break;
                    if (this.state == UploadProcessState.Paused) {
                        Thread.sleep(86400000L);
                        if (this.state != UploadProcessState.Paused) continue;
                        this.state = UploadProcessState.Timeout;
                        break;
                    }
                    int currentReadLen = this.inputStream.read(buffer, 0, this.bufferSize);
                    if (currentReadLen == -1) break;
                    if (bytesReaded + this.bufferSize >= totalBytes) {
                        currentReadLen = totalBytes - bytesReaded;
                        this.uploadSegFile(this.bucketName, headers, bytesReaded, currentReadLen, buffer);
                        this.eventArgs.setCompletedBytes(totalBytes);
                        this.eventArgs.setPercentage(1.0);
                        if (this.progressChangedCallback != null) {
                            this.progressChangedCallback.callback(this.eventArgs);
                        }
                        if (this.completeCallback != null) {
                            this.eventArgs.setFileId(this.fileId);
                            this.completeCallback.callback(this.eventArgs);
                        }
                        return;
                    }
                    this.uploadSegFile(this.bucketName, headers, bytesReaded, currentReadLen, buffer);
                    this.eventArgs.setCompletedBytes(bytesReaded + currentReadLen);
                    this.eventArgs.setPercentage((double)this.eventArgs.getCompletedBytes() / (double)this.eventArgs.getTotalBytes());
                    if (this.progressChangedCallback == null) continue;
                    this.progressChangedCallback.callback(this.eventArgs);
                }
                catch (Exception e) {
                    throw new OperateException(e);
                }
            }
        };
        ExecutorUtil.newExecutor().execute(runnable);
        return this;
    }

    public void uploadSegFile(String bucketName, Map<String, String> headers, int from, int count, byte[] buf) {
        String uri = String.format("%s/api/dmc/v1/buckets/%s/files/%s/%s/%s/%s/cover", ServerSetting.getServiceUrl(), bucketName, this.fileId, from, from + count - 1, this.eventArgs.getTotalBytes());
        HttpRequestUtil.uploadSegFile(uri, headers, count, buf);
    }

    @Override
    public ICoverSegmentDocumentUploader onProgressChanged(IUpLoadCallbackable callbackable) {
        this.progressChangedCallback = callbackable;
        return this;
    }

    @Override
    public ICoverSegmentDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }

    @Override
    public void pauseUpload() {
        this.state = UploadProcessState.Paused;
    }

    @Override
    public void continueUpload() {
        this.state = UploadProcessState.Uploading;
    }

    @Override
    public void stopUpload() {
        this.state = UploadProcessState.Stopped;
    }
}

