/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.NetworkOptions;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.upload.ISegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IUpLoadCallbackable;
import com.digiwin.dmc.sdk.service.upload.UploadProcessState;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class SegmentDocumentUploader
implements ISegmentDocumentUploader {
    private String discardTenantId;
    private String bucketName;
    private FileInfo fileInfo;
    private String driveToken;
    private int bufferSize = NetworkOptions.Default.getPackageSize();
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private IUpLoadCallbackable progressChangedCallback;
    private UploadProcessState state = UploadProcessState.NotStarted;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();
    private String uploadId;

    private SegmentDocumentUploader(String discardTenantId, String bucketName, FileInfo fileInfo, String driveToken) {
        this.discardTenantId = discardTenantId;
        this.bucketName = bucketName;
        this.fileInfo = fileInfo;
        this.driveToken = driveToken;
    }

    public SegmentDocumentUploader(String discardTenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        this(discardTenantId, bucketName, fileInfo, driveToken);
        try {
            this.inputStream = Files.newInputStream(Paths.get(localPath, new String[0]), new OpenOption[0]);
            this.eventArgs.setTotalBytes(this.inputStream.available());
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
    }

    public SegmentDocumentUploader(String discardTenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        this(discardTenantId, bucketName, fileInfo, driveToken);
        try {
            this.inputStream = new ByteArrayInputStream(bytes);
            this.eventArgs.setTotalBytes(this.inputStream.available());
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
    }

    @Override
    public ISegmentDocumentUploader beginUpload() {
        if (this.state != UploadProcessState.NotStarted) {
            throw new OperateException("\u4e0a\u4f20\u5df2\u5f00\u59cb\uff0c\u65e0\u6cd5\u518d\u6b21\u542f\u52a8\u4e0b\u8f7d\uff0c\u8bf7\u5f00\u542f\u65b0\u7684\u4e0a\u4f20");
        }
        try {
            this.bucketName = ArgumentUtils.getBucketName(this.bucketName);
            Map<String, String> headers = HttpUtils.setHeader(this.driveToken, this.discardTenantId, new TenantId[0]);
            this.uploadId = this.createEmptyFile(this.bucketName, headers);
            this.continueUpload();
            Runnable runnable = () -> this.multipartUpload(this.bucketName, headers);
            ExecutorUtil.newExecutor().execute(runnable);
            return this;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    private String createEmptyFile(String bucketName, Map<String, String> headers) throws Exception {
        String json;
        String uri = String.format("%s/api/dmc/v1/buckets/%s/files/segment", ServerSetting.getServiceUrl(), bucketName);
        Map result = HttpRequestUtil.postJson(uri, json = ObjectMapperUtil.writeValueAsString(this.fileInfo), headers, HashMap.class);
        if (result == null) {
            throw new Exception("Response is null");
        }
        return (String)result.get("id");
    }

    public void uploadSegFile(String bucketName, Map<String, String> headers, int from, int count, byte[] buf) {
        String uri = String.format("%s/api/dmc/v1/buckets/%s/files/%s/%s/%s/%s", ServerSetting.getServiceUrl(), bucketName, this.uploadId, from, from + count - 1, this.eventArgs.getTotalBytes());
        HttpRequestUtil.uploadSegFile(uri, headers, count, buf);
    }

    public void multipartUpload(String bucketName, Map<String, String> headers) {
        byte[] buffer = new byte[this.bufferSize];
        int bytesReaded = 0;
        int totalBytes = this.eventArgs.getTotalBytes();
        while (bytesReaded < totalBytes) {
            try {
                bytesReaded = this.eventArgs.getCompletedBytes();
                if (this.state == UploadProcessState.Stopped) break;
                if (this.state == UploadProcessState.Paused) {
                    Thread.sleep(86400000L);
                    if (this.state != UploadProcessState.Paused) continue;
                    this.state = UploadProcessState.Timeout;
                    break;
                }
                int currentReadLen = this.inputStream.read(buffer, 0, this.bufferSize);
                if (currentReadLen == -1) break;
                if (bytesReaded + this.bufferSize >= totalBytes) {
                    currentReadLen = totalBytes - bytesReaded;
                    this.uploadSegFile(bucketName, headers, bytesReaded, currentReadLen, buffer);
                    this.eventArgs.setCompletedBytes(totalBytes);
                    this.eventArgs.setPercentage(1.0);
                    if (this.progressChangedCallback != null) {
                        this.progressChangedCallback.callback(this.eventArgs);
                    }
                    if (this.completeCallback != null) {
                        this.eventArgs.setFileId(this.uploadId);
                        this.completeCallback.callback(this.eventArgs);
                    }
                    return;
                }
                this.uploadSegFile(bucketName, headers, bytesReaded, currentReadLen, buffer);
                this.eventArgs.setCompletedBytes(bytesReaded + currentReadLen);
                this.eventArgs.setPercentage((double)Math.round((double)this.eventArgs.getCompletedBytes() * 10000.0 / (double)totalBytes) / 10000.0);
                if (this.progressChangedCallback == null) continue;
                this.progressChangedCallback.callback(this.eventArgs);
            }
            catch (Exception e) {
                throw new OperateException(e);
            }
        }
    }

    @Override
    public ISegmentDocumentUploader onProgressChanged(IUpLoadCallbackable callbackable) {
        this.progressChangedCallback = callbackable;
        return this;
    }

    @Override
    public ISegmentDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }

    @Override
    public void pauseUpload() {
        this.state = UploadProcessState.Paused;
    }

    @Override
    public void continueUpload() {
        this.state = UploadProcessState.Uploading;
    }

    @Override
    public void stopUpload() {
        this.state = UploadProcessState.Stopped;
    }
}

