/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.upload.IShareUploader;
import com.digiwin.dmc.sdk.service.upload.IUpLoadCallbackable;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class ShareUploader
implements IShareUploader {
    private String bucketName;
    private FileInfo fileInfo;
    private String driveToken;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();

    private ShareUploader(String bucketName, FileInfo fileInfo, String driveToken) {
        this.bucketName = bucketName;
        this.fileInfo = fileInfo;
        this.driveToken = driveToken;
    }

    public ShareUploader(String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        this(bucketName, fileInfo, driveToken);
        try {
            this.inputStream = Files.newInputStream(Paths.get(localPath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    public ShareUploader(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        this(bucketName, fileInfo, driveToken);
        this.inputStream = new ByteArrayInputStream(bytes);
    }

    @Override
    public IShareUploader upload() {
        try {
            this.bucketName = ArgumentUtils.getBucketName(this.bucketName);
            String uri = String.format("%s/api/dmc/v1/buckets/%s/shareUploudFile", ServerSetting.getServiceUrl(), this.bucketName);
            Map<String, String> headers = HttpUtils.setHeader(this.driveToken, null, this.fileInfo, new TenantId[0]);
            Runnable runnable = () -> {
                Map result = HttpRequestUtil.uploadFile(uri, headers, this.inputStream, HashMap.class);
                String fileId = null;
                String url = null;
                if (result != null) {
                    fileId = (String)result.get("fileId");
                    url = (String)result.get("url");
                }
                if (this.completeCallback != null) {
                    this.eventArgs.setFileId(fileId);
                    this.eventArgs.setUrl(url);
                    this.eventArgs.setPercentage(1.0);
                    this.completeCallback.callback(this.eventArgs);
                }
            };
            ExecutorUtil.newExecutor().execute(runnable);
            return this;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public IShareUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}

