/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.util;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.BatchOperationIds;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.util.StringUtil;

public class ArgumentUtils {
    public static void uploadBytes(byte[] bytes, FileInfo fileInfo) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes is null ");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null ");
        }
    }

    public static void uploadBytes(byte[] bytes, String fileId, TenantId ... tenantId) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes is null ");
        }
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("The fileId is null ");
        }
        TenantId.checkId(tenantId);
    }

    public static void uploadLocal(String localPath, FileInfo fileInfo) {
        if (localPath == null) {
            throw new IllegalArgumentException("The localPath is null ");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null ");
        }
    }

    public static void uploadLocal(String localPath, String fileId, TenantId ... tenantId) {
        if (localPath == null) {
            throw new IllegalArgumentException("The localPath is null ");
        }
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("The fileId is null ");
        }
        TenantId.checkId(tenantId);
    }

    public static void download(String fileId, TenantId ... tenantId) {
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("The fileId is null ");
        }
        TenantId.checkId(tenantId);
    }

    public static void download(String fileId, String saveToPath, TenantId ... tenantId) {
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("The fileId is null ");
        }
        if (saveToPath == null) {
            throw new IllegalArgumentException("The saveToPath is null ");
        }
        TenantId.checkId(tenantId);
    }

    public static void fileInfo(String fileId, TenantId ... tenantId) {
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("The fileId is null");
        }
        TenantId.checkId(tenantId);
    }

    public static void fileInfo(String fileId, String fileName, TenantId ... tenantId) {
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("The fileId is null");
        }
        if (StringUtil.isEmpty(fileName)) {
            throw new IllegalArgumentException("The fileName is null");
        }
        TenantId.checkId(tenantId);
    }

    public static void fileInfo(BatchOperationIds operationIds, TenantId ... tenantId) {
        if (operationIds == null) {
            throw new IllegalArgumentException("The operationIds is null");
        }
        TenantId.checkId(tenantId);
    }

    public static void directory(String directoryId) {
        if (StringUtil.isEmpty(directoryId)) {
            throw new IllegalArgumentException("The directoryId is null");
        }
    }

    public static void directoryName(String directoryName) {
        if (StringUtil.isEmpty(directoryName)) {
            throw new IllegalArgumentException("The directoryName is null");
        }
    }

    public static void directory(String directoryId, String directoryName) {
        if (StringUtil.isEmpty(directoryId)) {
            throw new IllegalArgumentException("The directoryId is null");
        }
        if (StringUtil.isEmpty(directoryName)) {
            throw new IllegalArgumentException("The directoryName is null");
        }
    }

    public static String getBucketName(String bucketName) {
        if (StringUtil.isEmpty(bucketName)) {
            return ServerSetting.getBucketName();
        }
        return bucketName;
    }

    public static String getDirectoryId(String directoryId) {
        if (StringUtil.isEmpty(directoryId)) {
            return "00000000-0000-0000-0000-000000000000";
        }
        return directoryId;
    }
}

