/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorUtil {
    public static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultFactory.newThread(r);
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            thread.setName("dmc-sdk-" + this.threadNumber.getAndIncrement());
            return thread;
        }
    };
    private static final int CORE_POOL_SIZE = 0;
    private static final int MAX_POOL_SIZE = 10;
    private static ExecutorService executorService;

    public static ExecutorService newExecutor() {
        if (executorService == null) {
            executorService = new ThreadPoolExecutor(0, 10, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), THREAD_FACTORY);
        }
        return executorService;
    }

    public static void shutdown(ExecutorService executorService) {
        executorService.shutdownNow();
    }
}

