/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.util;

import com.digiwin.dmc.sdk.serializer.LocalDateDeserializer;
import com.digiwin.dmc.sdk.serializer.LocalDateSerializer;
import com.digiwin.dmc.sdk.serializer.LocalDateTimeDeserializer;
import com.digiwin.dmc.sdk.serializer.LocalDateTimeSerializer;
import com.digiwin.dmc.sdk.serializer.LocalTimeDeserializer;
import com.digiwin.dmc.sdk.serializer.LocalTimeSerializer;
import com.digiwin.dmc.sdk.serializer.TimestampDeserializer;
import com.digiwin.dmc.sdk.serializer.TimestampSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    private static final String JSON_SERIALIZER = "\u3010\u5e8f\u5217\u5316\u3011\uff1a{}";
    private static final String JSON_DESERIALIZER = "\u3010\u53cd\u5e8f\u5217\u5316\u3011\uff1a{}";
    private static volatile ObjectMapper objectMapper = null;

    public static String writeValueAsString(Object data) {
        try {
            return objectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            logger.error(JSON_SERIALIZER, (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T readValue(String content, Class<T> valueType) {
        try {
            return (T)objectMapper.readValue(content, valueType);
        }
        catch (IOException e) {
            logger.error(JSON_DESERIALIZER, (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T readValue(String json, TypeReference<T> valueTypeRef) {
        try {
            return (T)objectMapper.readValue(json, valueTypeRef);
        }
        catch (IOException e) {
            logger.error(JSON_DESERIALIZER, (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T readValue(InputStream src, Class<T> valueType) {
        try {
            return (T)JsonUtils.createObjectMapper().readValue(src, valueType);
        }
        catch (IOException e) {
            logger.error(JSON_DESERIALIZER, (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T readValue(InputStream src, TypeReference<T> valueTypeRef) {
        try {
            return (T)objectMapper.readValue(src, valueTypeRef);
        }
        catch (IOException e) {
            logger.error(JSON_DESERIALIZER, (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMapper createObjectMapper() {
        if (objectMapper != null) return objectMapper;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            if (objectMapper != null) return objectMapper;
            JavaTimeModule javaTimeModule = new JavaTimeModule();
            javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer());
            javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
            javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer());
            javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
            javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer());
            javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer());
            javaTimeModule.addSerializer(Timestamp.class, (JsonSerializer)new TimestampSerializer());
            javaTimeModule.addDeserializer(Timestamp.class, (JsonDeserializer)new TimestampDeserializer());
            objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)javaTimeModule);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return objectMapper;
        }
    }

    static {
        JsonUtils.createObjectMapper();
    }
}

