package com.digiwin.dap.middleware.dmc.common.security;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.commons.crypto.RSA;

public class RSAAESDigitalEnvelopeBuilder extends DigitalEnvelopeBuilder {

    public RSAAESDigitalEnvelopeBuilder(byte[] key) {
        super(key);
    }

    @Override
    public String digitalEnvelope(String publicKey) {
        byte[] ciphertext = RSA.encryptOAEP(super.key, publicKey);
        if (ciphertext.length > 0) {
            return Base64.encode(ciphertext);
        }
        throw new DMCException("数字信封生成失败!");
    }
}
