package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.common.utils.DMCUtils;

/**
 * Defines a builder that adds a config to the DMCConfig entity.
 *
 * @author fobgochod
 * @since 5.2.0.0
 */
public final class DMCConfigBuilder {

    private String uri;
    private String bucket;
    private String username;
    private String password;
    private String tenantId;
    private boolean lazy;
    private String appToken;
    private String appSecret;

    /**
     * Enforce the use of factory methods.
     */
    private DMCConfigBuilder() {
    }

    public static DMCConfigBuilder create() {
        DMCConfigBuilder configBuilder = new DMCConfigBuilder();
        LoadServerSetting.loadDefault(configBuilder);
        return configBuilder;
    }

    public static DMCConfigBuilder create(String uri, String username, String password, String bucket) {
        return new DMCConfigBuilder().uri(uri).username(username).password(password).bucket(bucket);
    }

    public DMCConfigBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public DMCConfigBuilder bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public DMCConfigBuilder username(String username) {
        this.username = username;
        return this;
    }

    public DMCConfigBuilder password(String password) {
        this.password = password;
        return this;
    }

    public DMCConfigBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public DMCConfigBuilder lazy(boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    public DMCConfigBuilder appToken(String appToken) {
        this.appToken = appToken;
        return this;
    }

    public DMCConfigBuilder appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public DMCConfig build() {
        DMCConfig config = new DMCConfig();
        config.setUri(uri);
        config.setBucket(bucket);
        config.setUsername(username);
        config.setPassword(password);
        if (password != null) {
            config.setPwdhash(DMCUtils.sha256(password));
        }
        config.setTenantId(tenantId);
        config.setLazy(lazy);
        config.setAppToken(appToken);
        config.setAppSecret(appSecret);
        return config;
    }
}
