package com.digiwin.dap.middleware.dmc.internal.client.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.common.security.RSAAESDecryptionDownloadResponse;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.DownloadPartRequest;
import com.digiwin.dap.middleware.dmc.model.DownloadRequest;

/**
 * 下载
 *
 * @author fobgochod
 * @date 2021/4/29
 */
public class DownloadV1EncryptionOperation extends DMCOperation {

    private final String publicKey;

    private final RSAAESDecryptionDownloadResponse rsaaesDecryptionDownloadResponse;

    public DownloadV1EncryptionOperation(ServiceClient client, String publicKey,
                                         RSAAESDecryptionDownloadResponse rsaaesDecryptionDownloadResponse) {
        super(client);
        this.publicKey = publicKey;
        this.rsaaesDecryptionDownloadResponse = rsaaesDecryptionDownloadResponse;
    }

    /**
     * 下载<br>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/files/{fileId}
     */
    public byte[] download(DownloadRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDownloadUrlV1(original.getBucket(), original.getFileId()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .setDMCSecurity(Boolean.TRUE)
                .setClientPublicKey(publicKey)
                .build();
        return rsaaesDecryptionDownloadResponse.decrypt(doOperation(request, ResponseParsers.downloadSecurityResponseParser));
    }

    /**
     * 分段下载<br>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/files/{fileId}/{position}/{length}
     */
    public byte[] downloadPart(DownloadPartRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDownloadPartUrlV1(original.getBucket(), original.getFileId(), original.getPosition(), original.getLength()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .setClientPublicKey(publicKey)
                .build();
        return rsaaesDecryptionDownloadResponse.decrypt(doOperation(request, ResponseParsers.downloadSecurityResponseParser));
    }
}


