package com.digiwin.dmc.sdk.service;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.entity.SharedFile;
import com.digiwin.dmc.sdk.service.upload.IShareUploader;

import java.util.List;

public interface IShareFileService {

    /**
     * 上传并分享
     * <p>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/shareUploudFile
     *
     * @param bytes    文件字节流
     * @param fileInfo 文件信息
     * @return 文档上传器
     */
    IShareUploader uploadDocument(byte[] bytes, FileInfo fileInfo);

    IShareUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo);

    IShareUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken);

    IShareUploader uploadDocument(String localPath, FileInfo fileInfo);

    IShareUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo);

    IShareUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo, String driveToken);


    /**
     * 文件永久分享给所有人
     * <p>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/ShareFiles
     *
     * @param fileIds 文件ID集合
     * @return 分享地址
     */
    List<String> perpetualShareFiles(List<String> fileIds);

    List<String> perpetualShareFiles(String bucketName, List<String> fileIds);

    List<String> perpetualShareFiles(String bucketName, List<String> fileIds, String driveToken);


    /**
     * 文件限时分享给所有人
     * <p>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/ShareFiles/d/{expireDay}
     *
     * @param fileIds 文件ID集合
     * @param day     分享天数
     * @return 分享地址
     */
    List<String> limitShareFiles(List<String> fileIds, int day);

    List<String> limitShareFiles(String bucketName, List<String> fileIds, int day);

    List<String> limitShareFiles(String bucketName, List<String> fileIds, int day, String driveToken);


    /**
     * 取消分享
     * <p>
     * {@link HttpMethod#DELETE} - /api/dmc/v1/{bucket}/deleteShareFile/{shareId}
     *
     * @param shareFileId 分享记录ID
     */
    void deleteShareFile(String shareFileId);

    void deleteShareFile(String bucketName, String shareFileId);

    void deleteShareFile(String bucketName, String shareFileId, String driveToken);


    /**
     * 获取我的分享
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/{bucket}/findMyShareFiles
     */
    List<SharedFile> getMyShareFiles();

    List<SharedFile> getMyShareFiles(String bucketName);

    List<SharedFile> getMyShareFiles(String bucketName, String driveToken);
}
