package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dap.middleware.dmc.internal.client.model.ShareV1Request;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.entity.SharedFile;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IShareFileService;
import com.digiwin.dmc.sdk.service.upload.IShareUploader;
import com.digiwin.dmc.sdk.service.upload.ShareUploader;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ShareFileService implements IShareFileService {

    /**
     * 单一实例
     */
    public static IShareFileService shareFileInstance() {
        return Holder.instance;
    }

    @Override
    public IShareUploader uploadDocument(byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocument(null, bytes, fileInfo, null);
    }

    @Override
    public IShareUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocument(bucketName, bytes, fileInfo, null);
    }

    @Override
    public IShareUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        ArgumentUtils.uploadBytes(bytes, fileInfo);
        return new ShareUploader(bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public IShareUploader uploadDocument(String localPath, FileInfo fileInfo) {
        return this.uploadDocument(null, localPath, fileInfo, null);
    }

    @Override
    public IShareUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo) {
        return this.uploadDocument(bucketName, localPath, fileInfo, null);
    }

    @Override
    public IShareUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        ArgumentUtils.uploadLocal(localPath, fileInfo);
        return new ShareUploader(bucketName, localPath, fileInfo, driveToken);
    }

    @Override
    public List<String> perpetualShareFiles(List<String> fileIds) {
        return this.perpetualShareFiles(null, fileIds, null);
    }

    @Override
    public List<String> perpetualShareFiles(String bucketName, List<String> fileIds) {
        return this.perpetualShareFiles(bucketName, fileIds, null);
    }

    @Override
    public List<String> perpetualShareFiles(String bucketName, List<String> fileIds, String driveToken) {
        if (fileIds == null || fileIds.isEmpty()) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken);
        ShareV1Request request = new ShareV1Request();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileIds(fileIds);
        return ServerSetting.internal().shareV1(request);
    }

    @Override
    public List<String> limitShareFiles(List<String> fileIds, int day) {
        return this.limitShareFiles(null, fileIds, day, null);
    }

    @Override
    public List<String> limitShareFiles(String bucketName, List<String> fileIds, int day) {
        return this.limitShareFiles(bucketName, fileIds, day, null);
    }

    @Override
    public List<String> limitShareFiles(String bucketName, List<String> fileIds, int day, String driveToken) {
        if (fileIds == null || fileIds.isEmpty()) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken);
        ShareV1Request request = new ShareV1Request();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileIds(fileIds);
        request.setExpireDay(day);
        return ServerSetting.internal().shareV1(request);
    }

    @Override
    public void deleteShareFile(String shareFileId) {
        this.deleteShareFile(null, shareFileId, null);
    }

    @Override
    public void deleteShareFile(String bucketName, String shareFileId) {
        this.deleteShareFile(bucketName, shareFileId, null);
    }

    @Override
    public void deleteShareFile(String bucketName, String shareFileId, String driveToken) {
        if ((shareFileId == null) || (shareFileId.isEmpty())) {
            throw new IllegalArgumentException("参数fileId is null");
        }
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken);

        ShareV1Request request = new ShareV1Request();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setShareId(shareFileId);
        ServerSetting.internal().deleteShareV1(request);
    }

    @Override
    public List<SharedFile> getMyShareFiles() {
        return this.getMyShareFiles(null, null);
    }

    @Override
    public List<SharedFile> getMyShareFiles(String bucketName) {
        return this.getMyShareFiles(bucketName, null);
    }

    @Override
    public List<SharedFile> getMyShareFiles(String bucketName, String driveToken) {
        try {
            String uri = String.format("%s/api/dmc/v1/%s/findMyShareFiles", ServerSetting.getServiceUrl(),
                    ArgumentUtils.getBucketName(bucketName));

            Map<String, String> headers = HttpUtils.setHeader(driveToken);
            List<SharedFile> sharedFileList = new ArrayList<>();
            SharedFile[] sharedFiles = HttpRequestUtil.get(uri, headers, SharedFile[].class);
            if (sharedFiles.length > 0) {
                sharedFileList = Arrays.asList(sharedFiles);
            }
            return sharedFileList;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    private static class Holder { // lazy class
        static final IShareFileService instance = new ShareFileService();
    }
}
