/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.security.encryption.strategy;

import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.security.encryption.strategy.AbstractEncryptionStrategy;
import com.digiwin.dap.middleware.dmc.common.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamEncryptionStrategy
extends AbstractEncryptionStrategy<InputStream> {
    protected static final Logger logger = LoggerFactory.getLogger(InputStreamEncryptionStrategy.class);

    public InputStreamEncryptionStrategy(byte[] aesKey) {
        super(aesKey);
    }

    @Override
    public InputStream encrypted(InputStream inputStream) {
        super.check(inputStream);
        try {
            byte[] ciphertext = AES.encryptIvCBC((byte[])IOUtils.readStreamAsByteArray(inputStream), (byte[])this.aesKey);
            if (ciphertext.length > 0) {
                return new ByteArrayInputStream(ciphertext);
            }
        }
        catch (Exception e) {
            throw new DMCException("inputStream\u52a0\u5bc6\u5f02\u5e38!", e);
        }
        throw new DMCException("inputStream\u52a0\u5bc6\u540e\u4e3a\u7a7a!");
    }
}

