/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dmc.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.dmc.common.parser.ResponseParser;
import com.digiwin.dap.middleware.dmc.common.utils.StreamUtils;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.model.StdData;
import com.digiwin.dap.middleware.dmc.model.Bucket;
import com.digiwin.dap.middleware.dmc.model.DirInfo;
import com.digiwin.dap.middleware.dmc.model.DownloadSecurity;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.FileOpId;
import com.digiwin.dap.middleware.dmc.model.FileOpTree;
import com.digiwin.dap.middleware.dmc.model.ImageInfo;
import com.digiwin.dap.middleware.dmc.model.ImageUpload;
import com.digiwin.dap.middleware.dmc.model.LoginToken;
import com.digiwin.dap.middleware.dmc.model.RecycleBin;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;

public final class ResponseParsers {
    public static final EmptyResponseParser emptyResponseParser = new EmptyResponseParser();
    public static final LoginResponseParser loginResponseParser = new LoginResponseParser();
    public static final UploadResponseParser uploadResponseParser = new UploadResponseParser();
    public static final UploadMultiResponseParser uploadMultiResponseParser = new UploadMultiResponseParser();
    public static final UploadMultipartResponseParser uploadMultipartResponseParser = new UploadMultipartResponseParser();
    public static final DownloadResponseParser downloadResponseParser = new DownloadResponseParser();
    public static final DeleteResponseParser deleteResponseParser = new DeleteResponseParser();
    public static final DeleteMultiResponseParser deleteMultiResponseParser = new DeleteMultiResponseParser();
    public static final CopyResponseParser copyResponseParser = new CopyResponseParser();
    public static final CopyDirResponseParser copyDirResponseParser = new CopyDirResponseParser();
    public static final CopyMultiResponseParser copyMultiResponseParser = new CopyMultiResponseParser();
    public static final ShareMultiResponseParser shareMultiResponseParser = new ShareMultiResponseParser();
    public static final ImageInfoResponseParser imageInfoResponseParser = new ImageInfoResponseParser();
    public static final ImageShrinkResponseParser imageShrinkResponseParser = new ImageShrinkResponseParser();
    public static final ImageUploadResponseParser imageUploadResponseParser = new ImageUploadResponseParser();
    public static final DirInfoResponseParser dirInfoResponseParser = new DirInfoResponseParser();
    public static final FileInfoResponseParser fileInfoResponseParser = new FileInfoResponseParser();
    public static final FileInfosResponseParser fileInfosResponseParser = new FileInfosResponseParser();
    public static final BucketResponseParser bucketResponseParser = new BucketResponseParser();
    public static final DownloadSecurityResponseParser downloadSecurityResponseParser = new DownloadSecurityResponseParser();
    private static final ObjectMapper objectMapper = JsonUtils.createObjectMapper();

    public static final class DownloadSecurityResponseParser
    implements ResponseParser<DownloadSecurity> {
        @Override
        public DownloadSecurity parse(ResponseMessage response) throws ResponseParseException {
            try {
                DownloadSecurity downloadSecurity = new DownloadSecurity(StreamUtils.copyToByteArray(response.getContent()), response.getHeaders());
                return downloadSecurity;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class BucketResponseParser
    implements ResponseParser<Bucket> {
        @Override
        public Bucket parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<Bucket>>(){});
                Bucket bucket = (Bucket)stdData.getData();
                return bucket;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class FileInfosResponseParser
    implements ResponseParser<List<FileInfo>> {
        @Override
        public List<FileInfo> parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<List<FileInfo>>>(){});
                List list = (List)stdData.getData();
                return list;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class FileInfoResponseParser
    implements ResponseParser<FileInfo> {
        @Override
        public FileInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<FileInfo>>(){});
                FileInfo fileInfo = (FileInfo)stdData.getData();
                return fileInfo;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class DirInfoResponseParser
    implements ResponseParser<DirInfo> {
        @Override
        public DirInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<DirInfo>>(){});
                DirInfo dirInfo = (DirInfo)stdData.getData();
                return dirInfo;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ImageUploadResponseParser
    implements ResponseParser<ImageUpload> {
        @Override
        public ImageUpload parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<ImageUpload>>(){});
                ImageUpload imageUpload = (ImageUpload)stdData.getData();
                return imageUpload;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ImageShrinkResponseParser
    implements ResponseParser<ImageInfo> {
        @Override
        public ImageInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<ImageInfo>>(){});
                ImageInfo imageInfo = (ImageInfo)stdData.getData();
                return imageInfo;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ImageInfoResponseParser
    implements ResponseParser<List<ImageInfo>> {
        @Override
        public List<ImageInfo> parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<List<ImageInfo>>>(){});
                List list = (List)stdData.getData();
                return list;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ShareMultiResponseParser
    implements ResponseParser<ShareInfo> {
        @Override
        public ShareInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<ShareInfo>>(){});
                ShareInfo shareInfo = (ShareInfo)stdData.getData();
                return shareInfo;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CopyMultiResponseParser
    implements ResponseParser<List<FileOpTree>> {
        @Override
        public List<FileOpTree> parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<List<FileOpTree>>>(){});
                List list = (List)stdData.getData();
                return list;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CopyDirResponseParser
    implements ResponseParser<String> {
        @Override
        public String parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<FileOpId>>(){});
                String string = ((FileOpId)stdData.getData()).getDirId();
                return string;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CopyResponseParser
    implements ResponseParser<String> {
        @Override
        public String parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<FileOpId>>(){});
                String string = ((FileOpId)stdData.getData()).getFileId();
                return string;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class DeleteMultiResponseParser
    implements ResponseParser<List<RecycleBin>> {
        @Override
        public List<RecycleBin> parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<List<RecycleBin>>>(){});
                List list = (List)stdData.getData();
                return list;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class DeleteResponseParser
    implements ResponseParser<RecycleBin> {
        @Override
        public RecycleBin parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<RecycleBin>>(){});
                RecycleBin recycleBin = (RecycleBin)stdData.getData();
                return recycleBin;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class DownloadResponseParser
    implements ResponseParser<byte[]> {
        @Override
        public byte[] parse(ResponseMessage response) throws ResponseParseException {
            try {
                byte[] byArray = StreamUtils.copyToByteArray(response.getContent());
                return byArray;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class UploadMultipartResponseParser
    implements ResponseParser<String> {
        @Override
        public String parse(ResponseMessage response) throws ResponseParseException {
            try {
                FileInfo fileInfo = (FileInfo)objectMapper.readValue(response.getContent(), FileInfo.class);
                String string = fileInfo.getId();
                return string;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class UploadMultiResponseParser
    implements ResponseParser<List<FileInfo>> {
        @Override
        public List<FileInfo> parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<List<FileInfo>>>(){});
                List list = (List)stdData.getData();
                return list;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class UploadResponseParser
    implements ResponseParser<FileInfo> {
        @Override
        public FileInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                StdData stdData = (StdData)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<StdData<FileInfo>>(){});
                FileInfo fileInfo = (FileInfo)stdData.getData();
                return fileInfo;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class LoginResponseParser
    implements ResponseParser<String> {
        @Override
        public String parse(ResponseMessage response) throws ResponseParseException {
            try {
                LoginToken result = (LoginToken)objectMapper.readValue(response.getContent(), LoginToken.class);
                String string = result.getUserToken();
                return string;
            }
            catch (Exception e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
            finally {
                DMCUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class EmptyResponseParser
    implements ResponseParser<ResponseMessage> {
        @Override
        public ResponseMessage parse(ResponseMessage response) throws ResponseParseException {
            DMCUtils.safeCloseResponse(response);
            return response;
        }
    }
}

